/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritGlobalStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.NonInheritingStrategy;
import org.jenkinsci.plugins.matrixauth.integrations.PermissionFinder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationProperty<T extends Describable<T>>
extends AuthorizationContainer<T> {
    public void setInheritanceStrategy(InheritanceStrategy var1);

    public InheritanceStrategy getInheritanceStrategy();

    @Deprecated
    default public void setBlocksInheritance(boolean blocksInheritance) {
        if (blocksInheritance) {
            this.setInheritanceStrategy(new NonInheritingStrategy());
        } else {
            this.setInheritanceStrategy(new InheritGlobalStrategy());
        }
    }

    @Deprecated
    default public boolean isBlocksInheritance() {
        return this.getInheritanceStrategy() instanceof NonInheritingStrategy;
    }

    @Restricted(value={DoNotUse.class})
    default public void setEntries(List<DslEntry> entries) {
        for (DslEntry entry : entries) {
            entry.addPermission(this);
        }
    }

    default public List<DslEntry> getEntries() {
        HashMap mapping = new HashMap();
        this.getGrantedPermissionEntries().forEach((permission, value) -> value.forEach(sid -> mapping.computeIfAbsent(sid, unused -> new TreeSet()).add(permission.group.getId() + "/" + permission.name)));
        return mapping.entrySet().stream().map(e -> {
            PermissionEntry key = (PermissionEntry)e.getKey();
            if (key.getType() == AuthorizationType.USER) {
                return new DslUser(key.getSid(), new ArrayList<String>((Collection)e.getValue()));
            }
            if (key.getType() == AuthorizationType.GROUP) {
                return new DslGroup(key.getSid(), new ArrayList<String>((Collection)e.getValue()));
            }
            if (key.getType() == AuthorizationType.EITHER) {
                return new DslUserOrGroup(key.getSid(), new ArrayList<String>((Collection)e.getValue()));
            }
            throw new IllegalStateException("Got unexpected key type in: " + key);
        }).distinct().sorted().collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class DslEntry
    implements Describable<DslEntry>,
    Comparable<DslEntry> {
        private final String name;
        private final List<String> permissions;

        public DslEntry(String name, List<String> permissions) {
            this.name = name;
            this.permissions = permissions;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPermissions() {
            return this.permissions;
        }

        public Descriptor<DslEntry> getDescriptor() {
            return Jenkins.get().getDescriptorOrDie(this.getClass());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DslEntry that = (DslEntry)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.permissions, that.permissions);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.permissions, this.getClass());
        }

        @Override
        public int compareTo(@NonNull DslEntry that) {
            if (this.getClass() != that.getClass()) {
                return this.getClass().getName().compareTo(that.getClass().getName());
            }
            if (!this.name.equals(that.name)) {
                return this.name.compareTo(that.name);
            }
            return this.permissions.size() - that.permissions.size();
        }

        public abstract void addPermission(AuthorizationProperty var1);

        protected static Permission findPermission(String value) {
            Permission permission = Permission.fromId((String)value);
            if (permission != null) {
                return permission;
            }
            return PermissionFinder.findPermission(value);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DslUser
    extends DslEntry {
        @DataBoundConstructor
        public DslUser(String name, List<String> permissions) {
            super(name, permissions);
        }

        @Override
        public void addPermission(AuthorizationProperty authorizationProperty) {
            this.getPermissions().forEach(permission -> authorizationProperty.add(DslUser.findPermission(permission), PermissionEntry.user(this.getName())));
        }

        @Extension
        @Symbol(value={"user"})
        public static class DescriptorImpl
        extends Descriptor<DslEntry> {
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DslGroup
    extends DslEntry {
        @DataBoundConstructor
        public DslGroup(String name, List<String> permissions) {
            super(name, permissions);
        }

        @Override
        public void addPermission(AuthorizationProperty authorizationProperty) {
            this.getPermissions().forEach(permission -> authorizationProperty.add(DslGroup.findPermission(permission), PermissionEntry.group(this.getName())));
        }

        @Extension
        @Symbol(value={"group"})
        public static class DescriptorImpl
        extends Descriptor<DslEntry> {
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DslUserOrGroup
    extends DslEntry {
        @DataBoundConstructor
        public DslUserOrGroup(String name, List<String> permissions) {
            super(name, permissions);
        }

        @Override
        public void addPermission(AuthorizationProperty authorizationProperty) {
            this.getPermissions().forEach(permission -> authorizationProperty.add(DslUserOrGroup.findPermission(permission), new PermissionEntry(AuthorizationType.EITHER, this.getName())));
        }

        @Extension
        @Symbol(value={"userOrGroup"})
        public static class DescriptorImpl
        extends Descriptor<DslEntry> {
        }
    }
}

