/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty;
import com.cloudbees.hudson.plugins.folder.properties.OptionalMarker;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.AmbiguityMonitor;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension(optional=true)
public class FolderContributor
implements AmbiguityMonitor.Contributor {
    public static final Logger LOGGER = Logger.getLogger(FolderContributor.class.getName());
    public final Map<String, Boolean> activeFolders = Collections.synchronizedMap(new TreeMap());

    @Override
    public boolean hasAmbiguousEntries() {
        return Jenkins.get().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy && this.activeFolders.values().stream().anyMatch(v -> v);
    }

    public static void record(AbstractFolder<?> folder) {
        if (AmbiguityMonitor.isGatheringData()) {
            boolean value = AmbiguityMonitor.hasAmbiguousEntries((AuthorizationContainer)folder.getProperties().get(AuthorizationMatrixProperty.class));
            LOGGER.log(Level.FINE, () -> "Recording folder " + folder + " as having ambiguous entries? " + value);
            ((FolderContributor)ExtensionList.lookupSingleton(FolderContributor.class)).activeFolders.put(folder.getFullName(), value);
        }
    }

    public static void remove(String folderName) {
        if (AmbiguityMonitor.isGatheringData()) {
            LOGGER.log(Level.FINE, () -> "Removing folder " + folderName);
            ((FolderContributor)ExtensionList.lookupSingleton(FolderContributor.class)).activeFolders.remove(folderName);
        }
    }

    public List<Item> getEntries() {
        return this.activeFolders.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(v -> Jenkins.get().getItemByFullName(v)).filter(Objects::nonNull).sorted(Comparator.comparing(Item::getFullDisplayName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    @Extension(optional=true)
    public static class FolderSaveableListenerImpl
    extends SaveableListener
    implements OptionalMarker<Folder> {
        public void onChange(Saveable o, XmlFile file) {
            try {
                if (o instanceof Folder) {
                    LOGGER.log(Level.FINEST, () -> "Recording update to Saveable " + o + " stored in " + file);
                    FolderContributor.record((Folder)o);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex, () -> "Exception while updating status for " + o);
            }
        }
    }

    @Extension(optional=true)
    public static class FolderListenerImpl
    extends ItemListener
    implements OptionalMarker<AbstractFolder<?>> {
        public void onCreated(Item item) {
            if (item instanceof AbstractFolder) {
                FolderContributor.record((AbstractFolder)item);
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (AmbiguityMonitor.isGatheringData() && item instanceof AbstractFolder) {
                FolderContributor.remove(oldFullName);
                FolderContributor.record((AbstractFolder)item);
            }
        }

        public void onDeleted(Item item) {
            if (AmbiguityMonitor.isGatheringData() && item instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)item;
                FolderContributor.remove(folder.getFullName());
            }
        }
    }
}

