/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.actions;

import com.mathworks.ci.MatlabBuilderConstants;
import com.mathworks.ci.MatlabExecutionException;
import com.mathworks.ci.Utilities;
import com.mathworks.ci.actions.MatlabAction;
import com.mathworks.ci.parameters.TestActionParameters;
import com.mathworks.ci.utilities.MatlabCommandRunner;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;

public class RunMatlabTestsAction
extends MatlabAction {
    private TestActionParameters params;

    public RunMatlabTestsAction(MatlabCommandRunner runner, TestActionParameters params) {
        super(runner);
        this.params = params;
    }

    public RunMatlabTestsAction(TestActionParameters params) throws IOException, InterruptedException {
        this(new MatlabCommandRunner(params), params);
    }

    public void run() throws IOException, InterruptedException, MatlabExecutionException {
        FilePath genScriptZip = this.runner.copyFileToTempFolder("matlab-script-generator.zip", "genscript.zip");
        genScriptZip.unzip(this.runner.getTempFolder());
        String command = MatlabBuilderConstants.TEST_RUNNER_SCRIPT;
        command = command.replace("${TEMP_FOLDER}", this.runner.getTempFolder().getRemote());
        command = command.replace("${PARAMS}", this.getParameterString());
        try {
            this.runner.runMatlabCommand(command);
        }
        catch (Exception e) {
            this.params.getTaskListener().getLogger().println(e.getMessage());
            throw e;
        }
        finally {
            Run<?, ?> build = this.params.getBuild();
            super.teardownAction(build);
        }
    }

    private String singleQuotify(String in) {
        return "'" + in.replace("'", "''") + "'";
    }

    private String getParameterString() {
        ArrayList<String> inputArgsList = new ArrayList<String>();
        inputArgsList.add("'Test'");
        String sourceFolders = null;
        if (this.params.getSourceFolder() != null) {
            sourceFolders = this.params.getSourceFolder().size() == 0 ? null : Utilities.getCellArrayFromList(this.params.getSourceFolder());
        }
        String selectFolders = null;
        if (this.params.getSelectByFolder() != null) {
            selectFolders = this.params.getSelectByFolder().size() == 0 ? null : Utilities.getCellArrayFromList(this.params.getSelectByFolder());
        }
        String[] names = new String[]{"'PDFTestReport'", "'TAPTestResults'", "'JUnitTestResults'", "'CoberturaCodeCoverage'", "'SimulinkTestResults'", "'CoberturaModelCoverage'", "'SelectByTag'", "'UseParallel'", "'Strict'", "'LoggingLevel'", "'OutputDetail'", "'SourceFolder'", "'SelectByFolder'"};
        String[] values = new String[]{this.params.getTestResultsPDF(), this.params.getTestResultsTAP(), this.params.getTestResultsJUnit(), this.params.getCodeCoverageCobertura(), this.params.getTestResultsSimulinkTest(), this.params.getModelCoverageCobertura(), this.params.getSelectByTag(), this.params.getUseParallel(), this.params.getStrict(), this.params.getLoggingLevel(), this.params.getOutputDetail(), sourceFolders, selectFolders};
        for (int i = 0; i < names.length; ++i) {
            if (values[i] == null || values[i].equals("false")) continue;
            inputArgsList.add(names[i]);
            String arg = values[i].equals("true") || values[i].startsWith("{") ? values[i] : this.singleQuotify(values[i]);
            inputArgsList.add(arg);
        }
        return String.join((CharSequence)",", inputArgsList);
    }
}

