/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabInstallation;
import com.mathworks.ci.MatlabNotFoundError;
import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Utilities {
    public static String getCellArrayFrmList(List<String> listOfStr) {
        Predicate<String> isEmpty = String::isEmpty;
        Predicate<String> isNotEmpty = isEmpty.negate();
        List filteredListOfStr = listOfStr.stream().filter(isNotEmpty).collect(Collectors.toList());
        filteredListOfStr.replaceAll(val -> "'" + val.replaceAll("'", "''") + "'");
        return "{" + String.join((CharSequence)",", filteredListOfStr) + "}";
    }

    public static void addMatlabToEnvPathFrmAxis(Computer cmp, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        String name = (String)env.get((Object)Message.getValue("Axis.matlab.key"));
        if (name == null || name.isEmpty() || env.get((Object)"matlabroot") != null) {
            return;
        }
        String matlabExecutablePath = Utilities.getNodeSpecificHome(name, cmp.getNode(), listener, env) + (Boolean.TRUE.equals(cmp.isUnix()) ? "/bin" : "\\bin");
        env.put("PATH+matlabroot", matlabExecutablePath);
        listener.getLogger().println("\n" + String.format(Message.getValue("matlab.added.to.path.from"), matlabExecutablePath) + "\n");
    }

    public static String getNodeSpecificHome(String instName, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        MatlabInstallation inst = MatlabInstallation.getInstallation(instName);
        if (inst == null || node == null) {
            return "";
        }
        FilePath matlabExecutablePath = node.createPath((inst = inst.forNode(node, listener).forEnvironment(env)).getHome());
        if (matlabExecutablePath == null || !matlabExecutablePath.exists()) {
            throw new MatlabNotFoundError(String.format(Message.getValue("matlab.not.found.error.for.node"), instName, Objects.requireNonNull(node).getDisplayName()));
        }
        return matlabExecutablePath.getRemote();
    }
}

