/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.google.common.collect.ImmutableSet;
import com.mathworks.ci.MatlabRunTestsStepExecution;
import com.mathworks.ci.Message;
import com.mathworks.ci.Utilities;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RunMatlabTestsStep
extends Step {
    private String testResultsPDF;
    private String testResultsTAP;
    private String testResultsJUnit;
    private String codeCoverageCobertura;
    private String testResultsSimulinkTest;
    private String modelCoverageCobertura;
    private String selectByTag;
    private String loggingLevel;
    private String outputDetail;
    private boolean useParallel;
    private boolean strict;
    private List<String> sourceFolder = new ArrayList<String>();
    private List<String> selectByFolder = new ArrayList<String>();
    private String startupOptions;

    @DataBoundConstructor
    public RunMatlabTestsStep() {
    }

    public String getTestResultsTAP() {
        return this.testResultsTAP;
    }

    @DataBoundSetter
    public void setTestResultsTAP(String testResultsTAP) {
        this.testResultsTAP = testResultsTAP;
    }

    public String getTestResultsPDF() {
        return this.testResultsPDF;
    }

    @DataBoundSetter
    public void setTestResultsPDF(String testResultsPDF) {
        this.testResultsPDF = testResultsPDF;
    }

    public String getTestResultsJUnit() {
        return this.testResultsJUnit;
    }

    @DataBoundSetter
    public void setTestResultsJUnit(String testResultsJUnit) {
        this.testResultsJUnit = testResultsJUnit;
    }

    public String getCodeCoverageCobertura() {
        return this.codeCoverageCobertura;
    }

    @DataBoundSetter
    public void setCodeCoverageCobertura(String codeCoverageCobertura) {
        this.codeCoverageCobertura = codeCoverageCobertura;
    }

    public String getTestResultsSimulinkTest() {
        return this.testResultsSimulinkTest;
    }

    @DataBoundSetter
    public void setTestResultsSimulinkTest(String testResultsSimulinkTest) {
        this.testResultsSimulinkTest = testResultsSimulinkTest;
    }

    public String getModelCoverageCobertura() {
        return this.modelCoverageCobertura;
    }

    @DataBoundSetter
    public void setModelCoverageCobertura(String modelCoverageCobertura) {
        this.modelCoverageCobertura = modelCoverageCobertura;
    }

    public List<String> getSourceFolder() {
        return this.sourceFolder;
    }

    @DataBoundSetter
    public void setSourceFolder(List<String> sourceFolder) {
        this.sourceFolder = Util.fixNull(sourceFolder);
    }

    public String getSelectByTag() {
        return this.selectByTag;
    }

    @DataBoundSetter
    public void setSelectByTag(String selectByTag) {
        this.selectByTag = selectByTag;
    }

    public List<String> getSelectByFolder() {
        return this.selectByFolder;
    }

    @DataBoundSetter
    public void setSelectByFolder(List<String> selectByFolder) {
        this.selectByFolder = selectByFolder;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    @DataBoundSetter
    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getOutputDetail() {
        return this.outputDetail;
    }

    @DataBoundSetter
    public void setOutputDetail(String outputDetail) {
        this.outputDetail = outputDetail;
    }

    public boolean getUseParallel() {
        return this.useParallel;
    }

    @DataBoundSetter
    public void setUseParallel(boolean useParallel) {
        this.useParallel = useParallel;
    }

    public boolean getStrict() {
        return this.strict;
    }

    @DataBoundSetter
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String getStartupOptions() {
        return Util.fixNull((String)this.startupOptions);
    }

    @DataBoundSetter
    public void setStartupOptions(String startupOptions) {
        this.startupOptions = startupOptions;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new MatlabRunTestsStepExecution(context, this.getInputArgs(), this.getStartupOptions());
    }

    private String getInputArgs() {
        ArrayList<String> inputArgs = new ArrayList<String>();
        Map<String, String> args = this.getGenscriptArgs();
        inputArgs.add("'Test'");
        args.forEach((key, val) -> {
            if (val != null) {
                if (key.equals("SourceFolder") || key.equals("SelectByFolder") || key.equals("UseParallel") || key.equals("Strict")) {
                    inputArgs.add("'" + key + "'," + val);
                } else {
                    inputArgs.add("'" + key + "','" + val.replaceAll("'", "''") + "'");
                }
            }
        });
        return String.join((CharSequence)",", inputArgs);
    }

    private Map<String, String> getGenscriptArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("PDFTestReport", this.getTestResultsPDF());
        args.put("TAPTestResults", this.getTestResultsTAP());
        args.put("JUnitTestResults", this.getTestResultsJUnit());
        args.put("SimulinkTestResults", this.getTestResultsSimulinkTest());
        args.put("CoberturaCodeCoverage", this.getCodeCoverageCobertura());
        args.put("CoberturaModelCoverage", this.getModelCoverageCobertura());
        args.put("SelectByTag", this.getSelectByTag());
        args.put("UseParallel", String.valueOf(this.getUseParallel()));
        args.put("Strict", String.valueOf(this.getStrict()));
        args.put("LoggingLevel", this.getLoggingLevel());
        args.put("OutputDetail", this.getOutputDetail());
        this.addFolderArgs("SourceFolder", this.getSourceFolder(), args);
        this.addFolderArgs("SelectByFolder", this.getSelectByFolder(), args);
        return args;
    }

    private void addFolderArgs(String argName, List<String> value, Map<String, String> args) {
        if (!value.isEmpty()) {
            args.put(argName, Utilities.getCellArrayFrmList(value));
        }
    }

    @Extension
    public static class RunTestsStepDescriptor
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class, Launcher.class, EnvVars.class, Run.class);
        }

        public String getFunctionName() {
            return Message.getValue("matlab.tests.build.step.name");
        }

        public String getDisplayName() {
            return Message.getValue("matlab.tests.step.display.name");
        }
    }
}

