/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.BuildArtifactAction;
import com.mathworks.ci.BuildConsoleAnnotator;
import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabExecutionException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class MatlabBuildStepExecution
extends SynchronousNonBlockingStepExecution<Void>
implements MatlabBuild {
    private static final long serialVersionUID = 4771831219402275744L;
    private String tasks;
    private String startupOptions;
    private String buildOptions;
    private static String DEFAULT_PLUGIN = "+ciplugins/+jenkins/getDefaultPlugins.m";
    private static String BUILD_REPORT_PLUGIN = "+ciplugins/+jenkins/BuildReportPlugin.m";
    private static String TASK_RUN_PROGRESS_PLUGIN = "+ciplugins/+jenkins/TaskRunProgressPlugin.m";

    public MatlabBuildStepExecution(StepContext context, String tasks, String startupOptions, String buildOptions) {
        super(context);
        this.tasks = tasks;
        this.startupOptions = startupOptions;
        this.buildOptions = buildOptions;
    }

    public Void run() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        Run build = (Run)this.getContext().get(Run.class);
        workspace.mkdirs();
        System.out.println("THE ROOT DIR IS" + build.getRootDir().toString());
        int exitCode = this.execMatlabCommand(workspace, launcher, listener, env, build);
        FilePath jsonFile = new FilePath(workspace, ".matlab/buildArtifact.json");
        if (jsonFile.exists()) {
            jsonFile.copyTo(new FilePath(new File(build.getRootDir().getAbsolutePath() + "/buildArtifact.json")));
            jsonFile.delete();
        }
        build.addAction((Action)new BuildArtifactAction(build, workspace));
        if (exitCode != 0) {
            this.stop(new MatlabExecutionException(exitCode));
        }
        this.getContext().setResult(Result.SUCCESS);
        return null;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * Loose catch block
     */
    private int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, Run<?, ?> build) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        String uniqueBuildFile = "build_" + this.getUniqueNameForRunnerFile().replaceAll("-", "_");
        FilePath uniqueTmpFolderPath = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
        this.createMatlabScriptByName(uniqueTmpFolderPath, uniqueBuildFile, listener, envVars);
        this.copyFileInWorkspace(DEFAULT_PLUGIN, DEFAULT_PLUGIN, uniqueTmpFolderPath);
        this.copyFileInWorkspace(BUILD_REPORT_PLUGIN, BUILD_REPORT_PLUGIN, uniqueTmpFolderPath);
        this.copyFileInWorkspace(TASK_RUN_PROGRESS_PLUGIN, TASK_RUN_PROGRESS_PLUGIN, uniqueTmpFolderPath);
        try {
            try (BuildConsoleAnnotator bca = new BuildConsoleAnnotator(listener.getLogger(), build.getCharset());){
                Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, bca, envVars, "setenv('MW_ORIG_WORKING_FOLDER', cd('" + uniqueTmpFolderPath.getRemote().replaceAll("'", "''") + "'));" + uniqueBuildFile, this.startupOptions, uniqueTmpFldrName);
                listener.getLogger().println("#################### Starting command output ####################");
                int n = matlabLauncher.pwd(workspace).join();
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (uniqueTmpFolderPath.exists()) {
                uniqueTmpFolderPath.deleteRecursive();
            }
        }
    }

    private void createMatlabScriptByName(FilePath uniqueTmpFolderPath, String uniqueScriptName, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        FilePath matlabBuildFile = new FilePath(uniqueTmpFolderPath, uniqueScriptName + ".m");
        String tasks = ((EnvVars)this.getContext().get(EnvVars.class)).expand(this.tasks);
        String buildOptions = ((EnvVars)this.getContext().get(EnvVars.class)).expand(this.buildOptions);
        envVars.put("MW_MATLAB_BUILDTOOL_DEFAULT_PLUGINS_FCN_OVERRIDE", "ciplugins.jenkins.getDefaultPlugins");
        String cmd = "buildtool";
        if (!tasks.trim().isEmpty()) {
            cmd = cmd + " " + tasks;
        }
        if (!buildOptions.trim().isEmpty()) {
            cmd = cmd + " " + buildOptions;
        }
        String matlabBuildFileContent = "addpath(pwd);cd(getenv('MW_ORIG_WORKING_FOLDER'));\n" + cmd;
        listener.getLogger().println("Generating MATLAB script with content:\n" + cmd + "\n");
        matlabBuildFile.write(matlabBuildFileContent, "UTF-8");
    }

    public Launcher.ProcStarter getProcessToRunMatlabCommand(FilePath workspace, Launcher launcher, BuildConsoleAnnotator bca, EnvVars envVars, String matlabCommand, String startupOpts, String uniqueName) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (launcher.isUnix()) {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "/" + ".matlab");
            ByteArrayOutputStream kernelStream = new ByteArrayOutputStream();
            launcher.launch().cmds(new String[]{"uname"}).masks(new boolean[]{true}).stdout((OutputStream)kernelStream).join();
            String runnerName = uniqueName + "/run-matlab-command";
            String binaryName = kernelStream.toString("UTF-8").contains("Linux") ? "glnxa64/run-matlab-command" : "maci64/run-matlab-command";
            args.add(".matlab/" + runnerName);
            args.add(matlabCommand);
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout((OutputStream)((Object)bca));
            this.copyFileInWorkspace(binaryName, runnerName, targetWorkspace);
        } else {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "\\" + ".matlab");
            String runnerName = uniqueName + "\\run-matlab-command.exe";
            args.add(new String[]{targetWorkspace.toString() + "\\" + runnerName, "\"" + matlabCommand + "\""});
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout((OutputStream)((Object)bca));
            this.copyFileInWorkspace("win64/run-matlab-command.exe", runnerName, targetWorkspace);
        }
        return matlabLauncher;
    }
}

