/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabExecutionException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class MatlabBuildStepExecution
extends SynchronousNonBlockingStepExecution<Void>
implements MatlabBuild {
    private static final long serialVersionUID = 4771831219402275744L;
    private String tasks;
    private String startupOptions;

    public MatlabBuildStepExecution(StepContext context, String tasks, String startupOptions) {
        super(context);
        this.tasks = tasks;
        this.startupOptions = startupOptions;
    }

    private String getTasks() {
        return this.tasks;
    }

    public Void run() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        workspace.mkdirs();
        int exitCode = this.execMatlabCommand(workspace, launcher, listener, env);
        if (exitCode != 0) {
            this.stop(new MatlabExecutionException(exitCode));
        }
        this.getContext().setResult(Result.SUCCESS);
        return null;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        String uniqueBuildFile = "build_" + this.getUniqueNameForRunnerFile().replaceAll("-", "_");
        FilePath uniqueTmpFolderPath = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
        this.createMatlabScriptByName(uniqueTmpFolderPath, uniqueBuildFile, workspace, listener);
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, "cd('" + uniqueTmpFolderPath.getRemote().replaceAll("'", "''") + "'); " + uniqueBuildFile, this.startupOptions, uniqueTmpFldrName);
            listener.getLogger().println("#################### Starting command output ####################");
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        finally {
            if (uniqueTmpFolderPath.exists()) {
                uniqueTmpFolderPath.deleteRecursive();
            }
        }
    }

    private void createMatlabScriptByName(FilePath uniqueTmpFolderPath, String uniqueScriptName, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        FilePath matlabBuildFile = new FilePath(uniqueTmpFolderPath, uniqueScriptName + ".m");
        String tasks = ((EnvVars)this.getContext().get(EnvVars.class)).expand(this.getTasks());
        String cmd = "buildtool";
        if (!tasks.trim().isEmpty()) {
            cmd = cmd + " " + tasks;
        }
        String matlabBuildFileContent = "cd '" + workspace.getRemote().replaceAll("'", "''") + "';\n" + cmd;
        listener.getLogger().println("Generating MATLAB script with content:\n" + cmd + "\n");
        matlabBuildFile.write(matlabBuildFileContent, "UTF-8");
    }
}

