/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.FormValidationUtil;
import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabReleaseInfo;
import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.MatrixPatternResolver;
import com.mathworks.ci.Message;
import com.mathworks.ci.UseMatlabVersionBuildWrapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabTestsBuilder
extends Builder
implements SimpleBuildStep,
MatlabBuild {
    private int buildResult;
    private EnvVars env;
    private boolean tapChkBx;
    private boolean junitChkBx;
    private boolean coberturaChkBx;
    private boolean stmResultsChkBx;
    private boolean modelCoverageChkBx;
    private boolean pdfReportChkBx;

    @DataBoundConstructor
    public RunMatlabTestsBuilder() {
    }

    @DataBoundSetter
    public void setTapChkBx(boolean tapChkBx) {
        this.tapChkBx = tapChkBx;
    }

    @DataBoundSetter
    public void setJunitChkBx(boolean junitChkBx) {
        this.junitChkBx = junitChkBx;
    }

    @DataBoundSetter
    public void setCoberturaChkBx(boolean coberturaChkBx) {
        this.coberturaChkBx = coberturaChkBx;
    }

    @DataBoundSetter
    public void setStmResultsChkBx(boolean stmResultsChkBx) {
        this.stmResultsChkBx = stmResultsChkBx;
    }

    @DataBoundSetter
    public void setModelCoverageChkBx(boolean modelCoverageChkBx) {
        this.modelCoverageChkBx = modelCoverageChkBx;
    }

    @DataBoundSetter
    public void setPdfReportChkBx(boolean pdfReportChkBx) {
        this.pdfReportChkBx = pdfReportChkBx;
    }

    public boolean getTapChkBx() {
        return this.tapChkBx;
    }

    public boolean getJunitChkBx() {
        return this.junitChkBx;
    }

    public boolean getCoberturaChkBx() {
        return this.coberturaChkBx;
    }

    public boolean getStmResultsChkBx() {
        return this.stmResultsChkBx;
    }

    public boolean getModelCoverageChkBx() {
        return this.modelCoverageChkBx;
    }

    public boolean getPdfReportChkBx() {
        return this.pdfReportChkBx;
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    private EnvVars getEnv() {
        return this.env;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.setEnv(build.getEnvironment(listener));
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener, this.getEnv());
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, this.constructCommandForTest(this.getInputArguments()), uniqueTmpFldrName);
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote());
            this.copyFileInWorkspace("com/mathworks/ci/MatlabBuilder/runMatlabTests.m", "runMatlabTests.m", targetWorkspace);
            int n = matlabLauncher.join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }

    public String constructCommandForTest(String inputArguments) {
        String matlabFunctionName = FilenameUtils.removeExtension((String)"runMatlabTests.m");
        String runCommand = "exit(" + matlabFunctionName + "(" + inputArguments + "))";
        return runCommand;
    }

    private String getInputArguments() {
        String pdfReport = "'PDFReport'," + this.getPdfReportChkBx();
        String tapResults = "'TAPResults'," + this.getTapChkBx();
        String junitResults = "'JUnitResults'," + this.getJunitChkBx();
        String stmResults = "'SimulinkTestResults'," + this.getStmResultsChkBx();
        String coberturaCodeCoverage = "'CoberturaCodeCoverage'," + this.getCoberturaChkBx();
        String coberturaModelCoverage = "'CoberturaModelCoverage'," + this.getModelCoverageChkBx();
        String inputArgsToMatlabFcn = pdfReport + "," + tapResults + "," + junitResults + "," + stmResults + "," + coberturaCodeCoverage + "," + coberturaModelCoverage;
        return inputArgsToMatlabFcn;
    }

    @Symbol(value={"RunMatlabTests"})
    @Extension
    public static class RunMatlabTestsDescriptor
    extends BuildStepDescriptor<Builder> {
        MatlabReleaseInfo rel;
        Function<String, FormValidation> chkCoberturaSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.3)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.cobertura.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkModelCoverageSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.5)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.modelcoverage.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkSTMResultsSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.6)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.exportstmresults.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };

        public String getDisplayName() {
            return Message.getBuilderDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }

        public FormValidation doCheckCoberturaChkBx(@QueryParameter boolean coberturaChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (coberturaChkBx) {
                listOfCheckMethods.add(this.chkCoberturaSupport);
            }
            return FormValidationUtil.getFirstErrorOrWarning(listOfCheckMethods, RunMatlabTestsDescriptor.getMatlabRoot());
        }

        public FormValidation doCheckModelCoverageChkBx(@QueryParameter boolean modelCoverageChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (modelCoverageChkBx) {
                listOfCheckMethods.add(this.chkModelCoverageSupport);
            }
            return FormValidationUtil.getFirstErrorOrWarning(listOfCheckMethods, RunMatlabTestsDescriptor.getMatlabRoot());
        }

        public FormValidation doCheckStmResultsChkBx(@QueryParameter boolean stmResultsChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (stmResultsChkBx) {
                listOfCheckMethods.add(this.chkSTMResultsSupport);
            }
            return FormValidationUtil.getFirstErrorOrWarning(listOfCheckMethods, RunMatlabTestsDescriptor.getMatlabRoot());
        }

        public static String getMatlabRoot() {
            try {
                return ((UseMatlabVersionBuildWrapper.UseMatlabVersionDescriptor)Jenkins.getInstance().getDescriptorByType(UseMatlabVersionBuildWrapper.UseMatlabVersionDescriptor.class)).getMatlabRootFolder();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

