/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.ListenerLogDecorator;
import com.mathworks.ci.MatlabReleaseInfo;
import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.Message;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MatlabBuilder
extends Builder
implements SimpleBuildStep {
    private static final double BASE_MATLAB_VERSION_RUNTESTS_SUPPORT = 8.1;
    private static final double BASE_MATLAB_VERSION_BATCH_SUPPORT = 9.5;
    private static final double BASE_MATLAB_VERSION_COBERTURA_SUPPORT = 9.3;
    private int buildResult;
    private TestRunTypeList testRunTypeList;
    private String localMatlab;
    private static final String MATLAB_RUNNER_TARGET_FILE = "Builder.matlab.runner.target.file.name";
    private static final String MATLAB_RUNNER_RESOURCE = "com/mathworks/ci/MatlabBuilder/runMatlabTests.m";

    @DataBoundConstructor
    public MatlabBuilder() {
    }

    @DataBoundSetter
    public void setLocalMatlab(String localMatlab) {
        this.localMatlab = localMatlab;
    }

    @DataBoundSetter
    public void setTestRunTypeList(TestRunTypeList testRunTypeList) {
        this.testRunTypeList = testRunTypeList;
    }

    public String getLocalMatlab() {
        return this.localMatlab;
    }

    public TestRunTypeList getTestRunTypeList() {
        return this.testRunTypeList;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        boolean isLinuxLauncher = launcher.isUnix();
        this.buildResult = this.execMatlabCommand(build, workspace, launcher, listener, env, isLinuxLauncher);
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    private int execMatlabCommand(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars env, boolean isLinuxLauncher) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        this.copyMatlabScratchFileInWorkspace(MATLAB_RUNNER_RESOURCE, MATLAB_RUNNER_TARGET_FILE, workspace, ((Object)((Object)this)).getClass().getClassLoader());
        try {
            MatlabReleaseInfo rel = new MatlabReleaseInfo(this.getLocalMatlab());
            matlabLauncher = launcher.launch().pwd(workspace).envs((Map)env);
            if (rel.verLessThan(9.5)) {
                ListenerLogDecorator outStream = new ListenerLogDecorator(listener);
                matlabLauncher = matlabLauncher.cmds(this.constructDefaultMatlabCommand(isLinuxLauncher)).stderr((OutputStream)((Object)outStream));
            } else {
                matlabLauncher = matlabLauncher.cmds(this.constructMatlabCommandWithBatch()).stdout(listener);
            }
        }
        catch (MatlabVersionNotFoundException e) {
            listener.getLogger().println(e.getMessage());
            return 1;
        }
        return matlabLauncher.join();
    }

    public List<String> constructMatlabCommandWithBatch() {
        String runCommand;
        String testRunMode = this.getTestRunTypeList().getDescriptor().getDisplayName();
        if (!testRunMode.equalsIgnoreCase(Message.getValue("builder.matlab.customcommandoption.display.name"))) {
            String matlabFunctionName = FilenameUtils.removeExtension((String)Message.getValue(MATLAB_RUNNER_TARGET_FILE));
            runCommand = "exit(" + matlabFunctionName + "(" + this.getTestRunTypeList().getBooleanByName("taJunitChkBx") + "," + this.getTestRunTypeList().getBooleanByName("tatapChkBx") + "," + this.getTestRunTypeList().getBooleanByName("taCoberturaChkBx") + "))";
        } else {
            runCommand = this.getTestRunTypeList().getStringByName("customMatlabCommand");
        }
        List<String> matlabDefaultArgs = Arrays.asList(this.localMatlab + File.separator + "bin" + File.separator + "matlab", "-batch", runCommand);
        return matlabDefaultArgs;
    }

    public List<String> constructDefaultMatlabCommand(boolean isLinuxLauncher) {
        ArrayList<String> matlabDefaultArgs = new ArrayList<String>();
        Collections.addAll(matlabDefaultArgs, this.getPreRunnerSwitches());
        if (!isLinuxLauncher) {
            matlabDefaultArgs.add("-noDisplayDesktop");
        }
        Collections.addAll(matlabDefaultArgs, this.getRunnerSwitch());
        if (!isLinuxLauncher) {
            matlabDefaultArgs.add("-wait");
        }
        Collections.addAll(matlabDefaultArgs, this.getPostRunnerSwitches());
        return matlabDefaultArgs;
    }

    private String[] getPreRunnerSwitches() {
        String[] preRunnerSwitches = new String[]{this.localMatlab + File.separator + "bin" + File.separator + "matlab", "-nosplash", "-nodesktop", "-noAppIcon"};
        return preRunnerSwitches;
    }

    private String[] getPostRunnerSwitches() {
        String[] postRunnerSwitch = new String[]{"-log"};
        return postRunnerSwitch;
    }

    private String[] getRunnerSwitch() {
        String runCommand;
        String testRunMode = this.getTestRunTypeList().getDescriptor().getDisplayName();
        if (!testRunMode.equalsIgnoreCase(Message.getValue("builder.matlab.customcommandoption.display.name"))) {
            String matlabFunctionName = FilenameUtils.removeExtension((String)Message.getValue(MATLAB_RUNNER_TARGET_FILE));
            runCommand = "try,exit(" + matlabFunctionName + "(" + this.getTestRunTypeList().getBooleanByName("taJunitChkBx") + "," + this.getTestRunTypeList().getBooleanByName("tatapChkBx") + "," + this.getTestRunTypeList().getBooleanByName("taCoberturaChkBx") + ")),catch e,disp(getReport(e,'extended')),exit(1),end";
        } else {
            runCommand = "try," + this.getTestRunTypeList().getStringByName("customMatlabCommand") + ",catch e,disp(getReport(e,'extended')),exit(1),end,exit";
        }
        String[] runnerSwitch = new String[]{"-r", runCommand};
        return runnerSwitch;
    }

    private void copyMatlabScratchFileInWorkspace(String matlabRunnerResourcePath, String matlabRunnerTarget, FilePath workspace, ClassLoader classLoader) throws IOException, InterruptedException {
        InputStream in = classLoader.getResourceAsStream(matlabRunnerResourcePath);
        Path target = new File(workspace.getRemote(), Message.getValue(matlabRunnerTarget)).toPath();
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public static class RunTestsWithCustomCommandOption
    extends TestRunTypeList {
        private String customMatlabCommand;

        @DataBoundConstructor
        public RunTestsWithCustomCommandOption() {
        }

        @DataBoundSetter
        public void setCustomMatlabCommand(String customMatlabCommand) {
            this.customMatlabCommand = customMatlabCommand;
        }

        public String getCustomMatlabCommand() {
            return this.customMatlabCommand;
        }

        @Override
        public boolean getBooleanByName(String memberName) {
            return false;
        }

        @Override
        public String getStringByName(String memberName) {
            switch (memberName) {
                case "customMatlabCommand": {
                    return this.getCustomMatlabCommand();
                }
            }
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends TestRunTypeDescriptor {
            public String getDisplayName() {
                return Message.getValue("builder.matlab.customcommandoption.display.name");
            }
        }
    }

    public static class RunTestsAutomaticallyOption
    extends TestRunTypeList {
        private boolean tatapChkBx;
        private boolean taJunitChkBx;
        private boolean taCoberturaChkBx;

        @DataBoundConstructor
        public RunTestsAutomaticallyOption() {
        }

        @DataBoundSetter
        public void setTatapChkBx(boolean tatapChkBx) {
            this.tatapChkBx = tatapChkBx;
        }

        @DataBoundSetter
        public void setTaJunitChkBx(boolean taJunitChkBx) {
            this.taJunitChkBx = taJunitChkBx;
        }

        @DataBoundSetter
        public void setTaCoberturaChkBx(boolean taCoberturaChkBx) {
            this.taCoberturaChkBx = taCoberturaChkBx;
        }

        public boolean getTatapChkBx() {
            return this.tatapChkBx;
        }

        public boolean getTaJunitChkBx() {
            return this.taJunitChkBx;
        }

        public boolean getTaCoberturaChkBx() {
            return this.taCoberturaChkBx;
        }

        @Override
        public boolean getBooleanByName(String memberName) {
            switch (memberName) {
                case "tatapChkBx": {
                    return this.getTatapChkBx();
                }
                case "taJunitChkBx": {
                    return this.getTaJunitChkBx();
                }
                case "taCoberturaChkBx": {
                    return this.getTaCoberturaChkBx();
                }
            }
            return false;
        }

        @Override
        public String getStringByName(String memberName) {
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends TestRunTypeDescriptor {
            public String getDisplayName() {
                return Message.getValue("builder.matlab.automatictestoption.display.name");
            }
        }
    }

    public static abstract class TestRunTypeDescriptor
    extends Descriptor<TestRunTypeList> {
        MatlabReleaseInfo rel;
        Function<String, FormValidation> chkCoberturaSupport = localMatlab -> {
            this.rel = new MatlabReleaseInfo((String)localMatlab);
            try {
                if (this.rel.verLessThan(9.3)) {
                    return FormValidation.warning((String)Message.getValue("Builder.matlab.cobertura.support.warning"));
                }
            }
            catch (MatlabVersionNotFoundException e) {
                return FormValidation.error((String)Message.getValue("Builder.invalid.matlab.root.error"));
            }
            return FormValidation.ok();
        };

        public FormValidation doCheckTaCoberturaChkBx(@QueryParameter boolean taCoberturaChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            String localMatlab = ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getLocalMatlab();
            if (taCoberturaChkBx) {
                listOfCheckMethods.add(this.chkCoberturaSupport);
            }
            return ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getFirstErrorOrWarning(listOfCheckMethods, localMatlab);
        }
    }

    public static abstract class TestRunTypeList
    implements ExtensionPoint,
    Describable<TestRunTypeList> {
        public abstract boolean getBooleanByName(String var1);

        public abstract String getStringByName(String var1);

        public Descriptor<TestRunTypeList> getDescriptor() {
            return Jenkins.getInstance().getDescriptor(this.getClass());
        }
    }

    @Extension
    public static class MatlabDescriptor
    extends BuildStepDescriptor<Builder> {
        MatlabReleaseInfo rel;
        String localMatlab;
        Function<String, FormValidation> chkMatlabEmpty = localMatlab -> {
            if (localMatlab.isEmpty()) {
                return FormValidation.error((String)Message.getValue("Builder.matlab.root.empty.error"));
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkMatlabSupportsRunTests = localMatlab -> {
            try {
                this.rel = new MatlabReleaseInfo((String)localMatlab);
                if (this.rel.verLessThan(8.1)) {
                    return FormValidation.error((String)Message.getValue("Builder.matlab.test.support.error"));
                }
            }
            catch (MatlabVersionNotFoundException e) {
                return FormValidation.error((String)Message.getValue("Builder.invalid.matlab.root.error"));
            }
            return FormValidation.ok();
        };

        public String getLocalMatlab() {
            return this.localMatlab;
        }

        public void setLocalMatlab(String localMatlab) {
            this.localMatlab = localMatlab;
        }

        public String getDisplayName() {
            return Message.getBuilderDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }

        public DescriptorExtensionList<TestRunTypeList, Descriptor<TestRunTypeList>> getTestRunTypeDescriptor() {
            return Jenkins.getInstance().getDescriptorList(TestRunTypeList.class);
        }

        public FormValidation doCheckLocalMatlab(@QueryParameter String localMatlab) {
            this.setLocalMatlab(localMatlab);
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            listOfCheckMethods.add(this.chkMatlabEmpty);
            listOfCheckMethods.add(this.chkMatlabSupportsRunTests);
            return this.getFirstErrorOrWarning(listOfCheckMethods, localMatlab);
        }

        public FormValidation getFirstErrorOrWarning(List<Function<String, FormValidation>> validations, String localMatalb) {
            if (validations == null || validations.isEmpty()) {
                return FormValidation.ok();
            }
            for (Function<String, FormValidation> val : validations) {
                FormValidation validationResult = val.apply(localMatalb);
                if (validationResult.kind.compareTo((Enum)FormValidation.Kind.ERROR) != 0 && validationResult.kind.compareTo((Enum)FormValidation.Kind.WARNING) != 0) continue;
                return validationResult;
            }
            return FormValidation.ok();
        }
    }
}

