/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.NotDirectoryException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.MapUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MatlabReleaseInfo {
    private String matlabRoot;
    private static final String VERSION_INFO_FILE = "VersionInfo.xml";
    private static final String VERSION_INFO_ROOT_TAG = "MathWorks_version_info";
    private static final String RELEASE_TAG = "release";
    private static final String VERSION_TAG = "version";
    private static final String DESCRIPTION_TAG = "description";
    private static final String DATE_TAG = "date";
    private static final String VERSION_16B = "9.1.0.888888";
    private static final Map<String, String> VERSION_OLDER_THAN_17A = new HashMap<String, String>(){
        {
            this.put(MatlabReleaseInfo.VERSION_TAG, MatlabReleaseInfo.VERSION_16B);
        }
    };
    private Map<String, String> versionInfoCache = new HashMap<String, String>();

    public MatlabReleaseInfo(String matlabRoot) {
        this.matlabRoot = matlabRoot;
    }

    public String getFullMatlabVersionNumber() throws MatlabVersionNotFoundException {
        Map<String, String> fullVersionNumber = this.getVersionInfoFromFile();
        return fullVersionNumber.get(VERSION_TAG);
    }

    private int getMatlabMajorVersionNumber() throws MatlabVersionNotFoundException {
        String[] version = this.getFullMatlabVersionNumber().split("[.]");
        return Integer.parseInt(version[0].trim());
    }

    private int getMatlabMinorVersionNumber() throws MatlabVersionNotFoundException {
        String[] version = this.getFullMatlabVersionNumber().split("[.]");
        if (version.length > 1) {
            return Integer.parseInt(version[1].trim());
        }
        return 0;
    }

    public boolean verLessThan(double version) throws MatlabVersionNotFoundException {
        double matlabVersion = Double.parseDouble(this.getMatlabMajorVersionNumber() + "." + this.getMatlabMinorVersionNumber());
        return Double.compare(matlabVersion, version) < 0;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Irrespective of exception type, intention is to handle it in same way. Also, there is no intention to propagate any runtime exception up in the hierarchy.")
    private Map<String, String> getVersionInfoFromFile() throws MatlabVersionNotFoundException {
        if (MapUtils.isEmpty(this.versionInfoCache)) {
            try {
                File versionFile = new File(this.matlabRoot + File.separator + VERSION_INFO_FILE);
                if (versionFile.isFile()) {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(versionFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName(VERSION_INFO_ROOT_TAG);
                    for (int temp = 0; temp < nList.getLength(); ++temp) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode;
                        this.versionInfoCache.put(RELEASE_TAG, eElement.getElementsByTagName(RELEASE_TAG).item(0).getTextContent());
                        this.versionInfoCache.put(VERSION_TAG, eElement.getElementsByTagName(VERSION_TAG).item(0).getTextContent());
                        this.versionInfoCache.put(DESCRIPTION_TAG, eElement.getElementsByTagName(DESCRIPTION_TAG).item(0).getTextContent());
                        this.versionInfoCache.put(DATE_TAG, eElement.getElementsByTagName(DATE_TAG).item(0).getTextContent());
                    }
                } else {
                    if (!new File(this.matlabRoot).exists()) {
                        throw new NotDirectoryException("Invalid matlabroot path");
                    }
                    this.versionInfoCache.putAll(VERSION_OLDER_THAN_17A);
                }
            }
            catch (Exception e) {
                throw new MatlabVersionNotFoundException(Message.getValue("Releaseinfo.matlab.version.not.found.error"), e);
            }
        }
        return this.versionInfoCache;
    }
}

