/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class MaskPasswordsOutputStream
extends LineTransformationOutputStream {
    private static final String MASKED_PASSWORD = "********";
    private final OutputStream logger;
    private final Pattern passwordsAsPattern;

    public MaskPasswordsOutputStream(OutputStream logger, @CheckForNull Collection<String> passwords, @CheckForNull Collection<String> regexes) {
        this.logger = logger;
        if (passwords != null && passwords.size() > 0 || regexes != null && regexes.size() > 0) {
            StringBuilder regex = new StringBuilder().append('(');
            int nbMaskedPasswords = 0;
            if (passwords != null && passwords.size() > 0) {
                for (String password : passwords) {
                    if (!StringUtils.isNotEmpty((String)password)) continue;
                    regex.append(Pattern.quote(password));
                    regex.append('|');
                    try {
                        String encodedPassword = URLEncoder.encode(password, "UTF-8");
                        if (!encodedPassword.equals(password)) {
                            regex.append(Pattern.quote(encodedPassword));
                            regex.append('|');
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    ++nbMaskedPasswords;
                }
            }
            if (regexes != null && regexes.size() > 0) {
                for (String user_regex : regexes) {
                    if (!StringUtils.isNotEmpty((String)user_regex)) continue;
                    regex.append(user_regex);
                    regex.append('|');
                    ++nbMaskedPasswords;
                }
            }
            if (nbMaskedPasswords++ >= 1) {
                regex.deleteCharAt(regex.length() - 1);
                regex.append(')');
                this.passwordsAsPattern = Pattern.compile(regex.toString());
            } else {
                this.passwordsAsPattern = null;
            }
        } else {
            this.passwordsAsPattern = null;
        }
    }

    public MaskPasswordsOutputStream(OutputStream logger, @CheckForNull Collection<String> passwords) {
        this(logger, passwords, null);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Open TODO item for wider rework")
    protected void eol(byte[] bytes, int len) throws IOException {
        String line = new String(bytes, 0, len);
        if (this.passwordsAsPattern != null) {
            line = this.passwordsAsPattern.matcher(line).replaceAll(MASKED_PASSWORD);
        }
        this.logger.write(line.getBytes());
    }

    public void close() throws IOException {
        super.close();
        this.logger.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.logger.flush();
    }
}

