/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsBuildWrapper;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsOutputStream;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class MaskPasswordsConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MaskPasswordsConsoleLogFilter.class.getName());

    public OutputStream decorateLogger(Run _ignore, OutputStream logger) throws IOException, InterruptedException {
        MaskPasswordsConfig config = MaskPasswordsConfig.getInstance();
        if (!config.isEnabledGlobally()) {
            LOGGER.log(Level.FINE, "MaskPasswords not enabled globally; not decorating logger");
            return logger;
        }
        LOGGER.log(Level.FINE, "MaskPasswords IS enabled globally; decorating logger");
        ArrayList<String> passwords = new ArrayList<String>();
        ArrayList<String> regexes = new ArrayList<String>();
        List<MaskPasswordsBuildWrapper.VarPasswordPair> globalVarPasswordPairs = config.getGlobalVarPasswordPairs();
        for (MaskPasswordsBuildWrapper.VarPasswordPair globalVarPasswordPair : globalVarPasswordPairs) {
            passwords.add(globalVarPasswordPair.getPlainTextPassword());
        }
        List<MaskPasswordsBuildWrapper.VarMaskRegex> globalVarMaskRegexes = config.getGlobalVarMaskRegexes();
        for (MaskPasswordsBuildWrapper.VarMaskRegex globalVarMaskRegex : globalVarMaskRegexes) {
            regexes.add(globalVarMaskRegex.getRegex());
        }
        return new MaskPasswordsOutputStream(logger, passwords, regexes);
    }
}

