/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.google.common.annotations.VisibleForTesting;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsBuildWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.cli.CLICommand;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterDefinition;
import hudson.model.PasswordParameterValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public class MaskPasswordsConfig {
    private static final String CONFIG_FILE = "com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml";
    private static Object CONFIG_FILE_LOCK = new Object();
    @GuardedBy(value="CONFIG_FILE_LOCK")
    private static MaskPasswordsConfig config;
    @GuardedBy(value="this")
    private Set<String> maskPasswordsParamDefClasses;
    @Nonnull
    @GuardedBy(value="this")
    private transient Set<String> paramValueCache_maskedClasses = new HashSet<String>();
    @Nonnull
    @GuardedBy(value="this")
    private transient Set<String> paramValueCache_nonMaskedClasses = new HashSet<String>();
    private List<MaskPasswordsBuildWrapper.VarPasswordPair> globalVarPasswordPairs;
    private List<MaskPasswordsBuildWrapper.VarMaskRegex> globalVarMaskRegexes;
    private boolean globalVarEnableGlobally;
    private static final String CLASS_NAME;
    private static final Logger LOGGER;

    public MaskPasswordsConfig() {
        this.maskPasswordsParamDefClasses = new LinkedHashSet<String>();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="readResolve()")
    private Object readResolve() {
        MaskPasswordsConfig maskPasswordsConfig = this;
        synchronized (maskPasswordsConfig) {
            if (this.paramValueCache_maskedClasses == null) {
                this.paramValueCache_maskedClasses = new HashSet<String>();
            }
            if (this.paramValueCache_nonMaskedClasses == null) {
                this.paramValueCache_nonMaskedClasses = new HashSet<String>();
            }
        }
        return this;
    }

    public void addGlobalVarPasswordPair(MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair) {
        if (StringUtils.isBlank((String)varPasswordPair.getVar()) || varPasswordPair.getPlainTextPassword() == null) {
            LOGGER.fine("addGlobalVarPasswordPair NOT adding pair with null var or password");
            return;
        }
        this.getGlobalVarPasswordPairsList().add(varPasswordPair);
    }

    public void addGlobalVarMaskRegex(MaskPasswordsBuildWrapper.VarMaskRegex varMaskRegex) {
        if (StringUtils.isBlank((String)varMaskRegex.getRegex())) {
            LOGGER.fine("addGlobalVarMaskRegex NOT adding null regex");
            return;
        }
        this.getGlobalVarMaskRegexesList().add(varMaskRegex);
    }

    public synchronized void addMaskedPasswordParameterDefinition(String className) {
        this.maskPasswordsParamDefClasses.add(className);
        this.paramValueCache_nonMaskedClasses.clear();
    }

    public void setGlobalVarEnabledGlobally(boolean state) {
        this.globalVarEnableGlobally = state;
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public final synchronized void reset() {
        this.clear();
        this.addMaskedPasswordParameterDefinition(PasswordParameterDefinition.class.getName());
        this.addMaskedPasswordParameterDefinition(com.michelin.cio.hudson.plugins.passwordparam.PasswordParameterDefinition.class.getName());
    }

    public synchronized void clear() {
        this.maskPasswordsParamDefClasses.clear();
        this.getGlobalVarPasswordPairsList().clear();
        this.getGlobalVarMaskRegexesList().clear();
        this.globalVarEnableGlobally = false;
        this.invalidatePasswordValueClassCaches();
    }

    synchronized void invalidatePasswordValueClassCaches() {
        this.paramValueCache_maskedClasses.clear();
        this.paramValueCache_nonMaskedClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MaskPasswordsConfig getInstance() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            if (config == null) {
                config = MaskPasswordsConfig.load();
            }
            return config;
        }
    }

    private static XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), CONFIG_FILE));
    }

    public List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairs() {
        ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair> r = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>(this.getGlobalVarPasswordPairsList().size());
        for (MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair : this.getGlobalVarPasswordPairsList()) {
            r.add((MaskPasswordsBuildWrapper.VarPasswordPair)varPasswordPair.clone());
        }
        return r;
    }

    public List<MaskPasswordsBuildWrapper.VarMaskRegex> getGlobalVarMaskRegexes() {
        ArrayList<MaskPasswordsBuildWrapper.VarMaskRegex> r = new ArrayList<MaskPasswordsBuildWrapper.VarMaskRegex>(this.getGlobalVarMaskRegexesList().size());
        for (MaskPasswordsBuildWrapper.VarMaskRegex varMaskRegex : this.getGlobalVarMaskRegexesList()) {
            r.add((MaskPasswordsBuildWrapper.VarMaskRegex)varMaskRegex.clone());
        }
        return r;
    }

    private List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairsList() {
        if (this.globalVarPasswordPairs == null) {
            this.globalVarPasswordPairs = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>();
        }
        return this.globalVarPasswordPairs;
    }

    private List<MaskPasswordsBuildWrapper.VarMaskRegex> getGlobalVarMaskRegexesList() {
        if (this.globalVarMaskRegexes == null) {
            this.globalVarMaskRegexes = new ArrayList<MaskPasswordsBuildWrapper.VarMaskRegex>();
        }
        return this.globalVarMaskRegexes;
    }

    public static Map<String, String> getParameterDefinitions() {
        HashMap<String, String> params = new HashMap<String, String>();
        ExtensionList paramExtensions = Jenkins.getActiveInstance().getExtensionList(ParameterDefinition.ParameterDescriptor.class);
        for (ParameterDefinition.ParameterDescriptor paramExtension : paramExtensions) {
            params.put(paramExtension.getClass().getEnclosingClass().getName(), paramExtension.getDisplayName());
        }
        return params;
    }

    public boolean isEnabledGlobally() {
        return this.globalVarEnableGlobally;
    }

    @Deprecated
    public synchronized boolean isMasked(@Nonnull String paramValueClassName) {
        return this.isMasked(null, paramValueClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMasked(@CheckForNull ParameterValue value, @Nonnull String paramValueClassName) {
        if (value != null && value.isSensitive()) {
            return true;
        }
        MaskPasswordsConfig maskPasswordsConfig = this;
        synchronized (maskPasswordsConfig) {
            if (this.paramValueCache_maskedClasses.contains(paramValueClassName)) {
                return true;
            }
            if (this.paramValueCache_nonMaskedClasses.contains(paramValueClassName)) {
                return false;
            }
            boolean guessSo = this.guessIfShouldMask(paramValueClassName);
            if (guessSo) {
                this.paramValueCache_maskedClasses.add(paramValueClassName);
                return true;
            }
            LOGGER.log(Level.WARNING, "Identified the {0} class as a ParameterValue class, which does not require masking. It may be false-negative", paramValueClassName);
            this.paramValueCache_nonMaskedClasses.add(paramValueClassName);
            return false;
        }
    }

    synchronized boolean guessIfShouldMask(@Nonnull String paramValueClassName) {
        Class<?> valueClass;
        for (String paramDefClassName : this.maskPasswordsParamDefClasses) {
            Class<?> paramDefClass;
            try {
                paramDefClass = Jenkins.getActiveInstance().getPluginManager().uberClassLoader.loadClass(paramDefClassName);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.WARNING, "Cannot check ParamDef for masking " + paramDefClassName, ex);
                continue;
            }
            this.tryProcessMethod(paramDefClass, "getDefaultParameterValue", true, new Class[0]);
            this.tryProcessMethod(paramDefClass, "createValue", true, StaplerRequest.class, JSONObject.class);
            this.tryProcessMethod(paramDefClass, "createValue", true, StaplerRequest.class);
            this.tryProcessMethod(paramDefClass, "createValue", true, CLICommand.class, String.class);
            this.tryProcessMethod(paramDefClass, "createValue", false, String.class);
            if (!this.paramValueCache_maskedClasses.contains(paramValueClassName)) continue;
            return true;
        }
        try {
            valueClass = Jenkins.getActiveInstance().getPluginManager().uberClassLoader.loadClass(paramValueClassName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load class for the ParameterValue " + paramValueClassName, ex);
            return false;
        }
        return PasswordParameterValue.class.isAssignableFrom(valueClass);
    }

    private synchronized void tryProcessMethod(Class<?> clazz, String methodName, boolean expectedToExist, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Level logLevel;
            Level level = logLevel = expectedToExist ? Level.INFO : Level.CONFIG;
            if (LOGGER.isLoggable(logLevel)) {
                String methodSpec = String.format("%s(%s)", methodName, StringUtils.join((Object[])parameterTypes, (String)","));
                LOGGER.log(logLevel, "No method {0} for class {1}", new Object[]{methodSpec, clazz});
            }
            return;
        }
        catch (RuntimeException ex) {
            Level logLevel;
            Level level = logLevel = expectedToExist ? Level.INFO : Level.CONFIG;
            if (LOGGER.isLoggable(logLevel)) {
                String methodSpec = String.format("%s(%s)", methodName, StringUtils.join((Object[])parameterTypes, (String)","));
                LOGGER.log(logLevel, "Failed to retrieve the method {0} for class {1}", new Object[]{methodSpec, clazz});
            }
            return;
        }
        Class<?> returnType = method.getReturnType();
        if (ParameterValue.class.isAssignableFrom(returnType) && !ParameterValue.class.equals(returnType)) {
            this.paramValueCache_maskedClasses.add(returnType.getName());
        }
    }

    public synchronized boolean isSelected(String paramDefClassName) {
        return this.maskPasswordsParamDefClasses.contains(paramDefClassName);
    }

    public static MaskPasswordsConfig load() {
        LOGGER.entering(CLASS_NAME, "load");
        try {
            return (MaskPasswordsConfig)MaskPasswordsConfig.getConfigFile().read();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            LOGGER.log(Level.WARNING, "No configuration found for Mask Passwords plugin");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to load Mask Passwords plugin configuration from com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml", e);
        }
        LOGGER.log(Level.FINE, "No Mask Passwords config file loaded; using defaults");
        return new MaskPasswordsConfig();
    }

    public static void save(MaskPasswordsConfig config) throws IOException {
        LOGGER.entering(CLASS_NAME, "save");
        MaskPasswordsConfig.getConfigFile().write((Object)config);
        LOGGER.exiting(CLASS_NAME, "save");
    }

    static {
        CLASS_NAME = MaskPasswordsConfig.class.getName();
        LOGGER = Logger.getLogger(CLASS_NAME);
    }
}

