/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsOutputStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public final class MaskPasswordsBuildWrapper
extends SimpleBuildWrapper {
    private final List<VarPasswordPair> varPasswordPairs;
    private final List<VarMaskRegex> varMaskRegexes;
    private static final Logger LOGGER = Logger.getLogger(MaskPasswordsBuildWrapper.class.getName());

    @DataBoundConstructor
    public MaskPasswordsBuildWrapper(List<VarPasswordPair> varPasswordPairs, List<VarMaskRegex> varMaskRegexes) {
        this.varPasswordPairs = varPasswordPairs;
        this.varMaskRegexes = varMaskRegexes;
    }

    public MaskPasswordsBuildWrapper(List<VarPasswordPair> varPasswordPairs) {
        this.varPasswordPairs = varPasswordPairs;
        this.varMaskRegexes = new ArrayList<VarMaskRegex>();
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        ParametersAction parametersAction;
        ArrayList<String> allPasswords = new ArrayList<String>();
        ArrayList<String> allRegexes = new ArrayList<String>();
        MaskPasswordsConfig config = MaskPasswordsConfig.getInstance();
        List<VarPasswordPair> globalVarPasswordPairs = config.getGlobalVarPasswordPairs();
        for (VarPasswordPair varPasswordPair : globalVarPasswordPairs) {
            allPasswords.add(varPasswordPair.getPlainTextPassword());
        }
        List<VarMaskRegex> globalVarMaskRegexes = config.getGlobalVarMaskRegexes();
        for (VarMaskRegex globalVarMaskRegex : globalVarMaskRegexes) {
            allRegexes.add(globalVarMaskRegex.getRegex());
        }
        if (this.varPasswordPairs != null) {
            for (VarPasswordPair varPasswordPair : this.varPasswordPairs) {
                String password = varPasswordPair.getPlainTextPassword();
                if (!StringUtils.isNotBlank((String)password)) continue;
                allPasswords.add(password);
            }
        }
        if (this.varMaskRegexes != null) {
            for (VarMaskRegex varMaskRegex : this.varMaskRegexes) {
                String regex = varMaskRegex.getRegex();
                if (!StringUtils.isNotBlank((String)regex)) continue;
                allRegexes.add(regex);
            }
        }
        if ((parametersAction = (ParametersAction)build.getAction(ParametersAction.class)) != null) {
            for (ParameterValue param : parametersAction) {
                if (!config.isMasked(param, param.getClass().getName())) continue;
                EnvVars env = new EnvVars();
                param.buildEnvironment(build, env);
                String password = (String)env.get((Object)param.getName());
                if (!StringUtils.isNotBlank((String)password)) continue;
                allPasswords.add(password);
            }
        }
        return new FilterImpl(allPasswords, allRegexes);
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        MaskPasswordsConfig config = MaskPasswordsConfig.getInstance();
        List<VarPasswordPair> globalVarPasswordPairs = config.getGlobalVarPasswordPairs();
        for (VarPasswordPair globalVarPasswordPair : globalVarPasswordPairs) {
            variables.put(globalVarPasswordPair.getVar(), globalVarPasswordPair.getPlainTextPassword());
        }
        if (this.varPasswordPairs != null) {
            for (VarPasswordPair varPasswordPair : this.varPasswordPairs) {
                if (!StringUtils.isNotBlank((String)varPasswordPair.getVar())) continue;
                variables.put(varPasswordPair.getVar(), varPasswordPair.getPlainTextPassword());
            }
        }
    }

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        TreeMap<String, String> variables = new TreeMap<String, String>();
        this.makeBuildVariables(build, variables);
        sensitiveVariables.addAll(variables.keySet());
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
    }

    public List<VarPasswordPair> getVarPasswordPairs() {
        return this.varPasswordPairs;
    }

    public List<VarMaskRegex> getVarMaskRegexes() {
        return this.varMaskRegexes;
    }

    public static final class ConverterImpl
    implements Converter {
        private static final String VAR_PASSWORD_PAIRS_NODE = "varPasswordPairs";
        private static final String VAR_PASSWORD_PAIR_NODE = "varPasswordPair";
        private static final String VAR_MASK_REGEXES_NODE = "varMaskRegexes";
        private static final String VAR_MASK_REGEX_NODE = "varMaskRegex";
        private static final String VAR_ATT = "var";
        private static final String PASSWORD_ATT = "password";
        private static final String REGEX_ATT = "regex";

        public boolean canConvert(Class clazz) {
            return clazz.equals(MaskPasswordsBuildWrapper.class);
        }

        public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mc) {
            MaskPasswordsBuildWrapper maskPasswordsBuildWrapper = (MaskPasswordsBuildWrapper)((Object)o);
            if (maskPasswordsBuildWrapper.getVarPasswordPairs() != null) {
                writer.startNode(VAR_PASSWORD_PAIRS_NODE);
                for (VarPasswordPair varPasswordPair : maskPasswordsBuildWrapper.getVarPasswordPairs()) {
                    if (varPasswordPair.getPlainTextPassword() == null) continue;
                    writer.startNode(VAR_PASSWORD_PAIR_NODE);
                    writer.addAttribute(VAR_ATT, varPasswordPair.getVar());
                    writer.addAttribute(PASSWORD_ATT, varPasswordPair.getPassword().getEncryptedValue());
                    writer.endNode();
                }
                writer.endNode();
            }
            if (maskPasswordsBuildWrapper.getVarMaskRegexes() != null) {
                writer.startNode(VAR_MASK_REGEXES_NODE);
                for (VarMaskRegex varMaskRegex : maskPasswordsBuildWrapper.getVarMaskRegexes()) {
                    if (StringUtils.isBlank((String)varMaskRegex.getRegex())) continue;
                    writer.startNode(VAR_MASK_REGEX_NODE);
                    writer.addAttribute(REGEX_ATT, varMaskRegex.getRegex());
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext uc) {
            ArrayList<VarPasswordPair> varPasswordPairs = new ArrayList<VarPasswordPair>();
            ArrayList<VarMaskRegex> varMaskRegexes = new ArrayList<VarMaskRegex>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals(VAR_PASSWORD_PAIRS_NODE)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (reader.getNodeName().equals(VAR_PASSWORD_PAIR_NODE)) {
                            varPasswordPairs.add(new VarPasswordPair(reader.getAttribute(VAR_ATT), Secret.fromString((String)reader.getAttribute(PASSWORD_ATT))));
                        } else {
                            LOGGER.log(Level.WARNING, "Encountered incorrect node name: Expected \"varPasswordPair\", got \"{0}\"", reader.getNodeName());
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                    continue;
                }
                if (reader.getNodeName().equals(VAR_MASK_REGEXES_NODE)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (reader.getNodeName().equals(VAR_MASK_REGEX_NODE)) {
                            varMaskRegexes.add(new VarMaskRegex(reader.getAttribute(REGEX_ATT)));
                        } else {
                            LOGGER.log(Level.WARNING, "Encountered incorrect node name: Expected \"varMaskRegex\", got \"{0}\"", reader.getNodeName());
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                    continue;
                }
                LOGGER.log(Level.WARNING, "Encountered incorrect node name: \"{0}\"", reader.getNodeName());
            }
            return new MaskPasswordsBuildWrapper(varPasswordPairs, varMaskRegexes);
        }
    }

    @Symbol(value={"maskPasswords"})
    @Extension(ordinal=100.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(MaskPasswordsBuildWrapper.class);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                boolean b;
                JSONObject jsonObject;
                int i;
                JSONArray jsonArray;
                this.getConfig().clear();
                LOGGER.fine("Processing the maskedParamDefs and selectedMaskedParamDefs JSON objects");
                JSONObject submittedForm = req.getSubmittedForm();
                JSONArray paramDefinitions = submittedForm.getJSONArray("maskedParamDefs");
                JSONArray selectedParamDefinitions = submittedForm.getJSONArray("selectedMaskedParamDefs");
                for (int i2 = 0; i2 < selectedParamDefinitions.size(); ++i2) {
                    if (!selectedParamDefinitions.getBoolean(i2)) continue;
                    this.getConfig().addMaskedPasswordParameterDefinition(paramDefinitions.getString(i2));
                }
                if (submittedForm.has("globalVarPasswordPairs")) {
                    Object o = submittedForm.get("globalVarPasswordPairs");
                    if (o instanceof JSONArray) {
                        jsonArray = submittedForm.getJSONArray("globalVarPasswordPairs");
                        for (i = 0; i < jsonArray.size(); ++i) {
                            this.getConfig().addGlobalVarPasswordPair(new VarPasswordPair(jsonArray.getJSONObject(i).getString("var"), Secret.fromString((String)jsonArray.getJSONObject(i).getString("password"))));
                        }
                    } else if (o instanceof JSONObject) {
                        jsonObject = submittedForm.getJSONObject("globalVarPasswordPairs");
                        this.getConfig().addGlobalVarPasswordPair(new VarPasswordPair(jsonObject.getString("var"), Secret.fromString((String)jsonObject.getString("password"))));
                    }
                }
                if (submittedForm.has("globalVarMaskRegexes")) {
                    Object o = submittedForm.get("globalVarMaskRegexes");
                    if (o instanceof JSONArray) {
                        jsonArray = submittedForm.getJSONArray("globalVarMaskRegexes");
                        for (i = 0; i < jsonArray.size(); ++i) {
                            this.getConfig().addGlobalVarMaskRegex(new VarMaskRegex(jsonArray.getJSONObject(i).getString("regex")));
                        }
                    } else if (o instanceof JSONObject) {
                        jsonObject = submittedForm.getJSONObject("globalVarMaskRegexes");
                        this.getConfig().addGlobalVarMaskRegex(new VarMaskRegex(jsonObject.getString("regex")));
                    }
                }
                if (submittedForm.has("globalVarMaskEnabledGlobally") && (b = submittedForm.getBoolean("globalVarMaskEnabledGlobally"))) {
                    this.getConfig().setGlobalVarEnabledGlobally(true);
                }
                MaskPasswordsConfig.save(this.getConfig());
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to save Mask Passwords plugin configuration", e);
                return false;
            }
        }

        public List<VarPasswordPair> getGlobalVarPasswordPairs() {
            return this.getConfig().getGlobalVarPasswordPairs();
        }

        public List<VarMaskRegex> getGlobalVarMaskRegexes() {
            return this.getConfig().getGlobalVarMaskRegexes();
        }

        public MaskPasswordsConfig getConfig() {
            return MaskPasswordsConfig.getInstance();
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MaskPasswordsBuildWrapper.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    public static class VarMaskRegex
    extends AbstractDescribableImpl<VarMaskRegex>
    implements Cloneable {
        private final String regex;

        @DataBoundConstructor
        public VarMaskRegex(String regex) {
            this.regex = regex;
        }

        @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="We do not expect anybody to use this class.If they do, they must override clone() as well")
        public Object clone() {
            return new VarMaskRegex(this.getRegex());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VarMaskRegex other = (VarMaskRegex)obj;
            return Objects.equals(this.regex, other.regex);
        }

        @CheckForNull
        public String getRegex() {
            return this.regex;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.regex != null ? this.regex.hashCode() : 0);
            return hash;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<VarMaskRegex> {
        }
    }

    public static class VarPasswordPair
    extends AbstractDescribableImpl<VarPasswordPair>
    implements Cloneable {
        private final String var;
        private final Secret password;

        @DataBoundConstructor
        public VarPasswordPair(String var, Secret password) {
            this.var = var;
            this.password = password;
        }

        @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="We do not expect anybody to use this class.If they do, they must override clone() as well")
        public Object clone() {
            return new VarPasswordPair(this.getVar(), this.password);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VarPasswordPair other = (VarPasswordPair)obj;
            return Objects.equals(this.var, other.var);
        }

        public String getVar() {
            return this.var;
        }

        public Secret getPassword() {
            return this.password;
        }

        public String getPlainTextPassword() {
            if (this.password == null || StringUtils.isBlank((String)this.password.getPlainText())) {
                return null;
            }
            return this.password.getPlainText();
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.var != null ? this.var.hashCode() : 0);
            return hash;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<VarPasswordPair>
        implements CustomDescribableModel {
            @Nonnull
            public UninstantiatedDescribable customUninstantiate(@Nonnull UninstantiatedDescribable step) {
                Map arguments = step.getArguments();
                HashMap newMap1 = new HashMap();
                newMap1.put("var", arguments.get("var"));
                newMap1.put("password", ((Secret)arguments.get("password")).getPlainText());
                return step.withArguments(newMap1);
            }

            @Nonnull
            public Map<String, Object> customInstantiate(@Nonnull Map<String, Object> arguments) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                newMap.put("var", arguments.get("var"));
                Object password = arguments.get("password");
                if (password instanceof String) {
                    password = Secret.fromString((String)((String)password));
                }
                newMap.put("password", password);
                return newMap;
            }
        }
    }

    private static final class FilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Secret> allPasswords = new ArrayList<Secret>();
        private final List<String> allRegexes = new ArrayList<String>();

        FilterImpl(List<String> allPasswords, List<String> allRegexes) {
            for (String password : allPasswords) {
                this.allPasswords.add(Secret.fromString((String)password));
            }
            for (String regex : allRegexes) {
                this.allRegexes.add(regex);
            }
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            ArrayList<String> passwords = new ArrayList<String>();
            ArrayList<String> regexes = new ArrayList<String>();
            for (Secret password : this.allPasswords) {
                passwords.add(password.getPlainText());
            }
            for (String regex : this.allRegexes) {
                regexes.add(regex);
            }
            return new MaskPasswordsOutputStream(logger, passwords, regexes);
        }
    }
}

