/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import java.io.IOException;
import jenkins.plugins.logstash.persistence.HostBasedLogstashIndexerDao;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public class RedisDao
extends HostBasedLogstashIndexerDao {
    private final JedisPool pool;
    private final String password;
    private final String key;

    public RedisDao(String host, int port, String key, String password) {
        this(null, host, port, key, password);
    }

    RedisDao(JedisPool factory, String host, int port, String key, String password) {
        super(host, port);
        this.key = key;
        this.password = password;
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("redis key is required");
        }
        this.pool = factory == null ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port) : factory;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void push(String data) throws IOException {
        Jedis jedis = null;
        boolean connectionBroken = false;
        try {
            jedis = this.pool.getResource();
            if (!StringUtils.isBlank((String)this.password)) {
                jedis.auth(this.password);
            }
            jedis.connect();
            long result = jedis.rpush(this.key, new String[]{data});
            jedis.disconnect();
            if (result <= 0L) {
                throw new IOException("Failed to push results");
            }
        }
        catch (JedisException e) {
            connectionBroken = e instanceof JedisConnectionException;
            throw new IOException(e);
        }
        finally {
            if (jedis != null) {
                if (connectionBroken) {
                    this.pool.returnBrokenResource(jedis);
                } else {
                    this.pool.returnResource(jedis);
                }
            }
        }
    }
}

