/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.configuration;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import jenkins.model.Jenkins;
import jenkins.plugins.logstash.Messages;
import jenkins.plugins.logstash.configuration.LogstashIndexer;
import jenkins.plugins.logstash.persistence.ElasticSearchDao;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElasticSearch
extends LogstashIndexer<ElasticSearchDao> {
    private static final Logger LOGGER = Logger.getLogger(ElasticSearch.class.getName());
    private String username;
    private Secret password;
    private URI uri;
    private String mimeType;
    private String customServerCertificateId;

    @DataBoundConstructor
    public ElasticSearch() {
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public void validate() throws MimeTypeParseException {
        new MimeType(this.mimeType);
    }

    @DataBoundSetter
    public void setUri(URL url) throws URISyntaxException {
        this.uri = url.toURI();
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = Secret.fromString((String)password);
    }

    @DataBoundSetter
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @DataBoundSetter
    public void setCustomServerCertificateId(String customServerCertificateId) {
        this.customServerCertificateId = customServerCertificateId;
    }

    public String getCustomServerCertificateId() {
        return this.customServerCertificateId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ElasticSearch other = (ElasticSearch)((Object)obj);
        if (!Secret.toString((Secret)this.password).equals(other.getPassword())) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        if (this.username == null) {
            if (other.username != null) {
                return false;
            }
        } else {
            if (!this.username.equals(other.username)) {
                return false;
            }
            if (!this.mimeType.equals(other.mimeType)) {
                return false;
            }
        }
        return !(this.customServerCertificateId == null ? other.customServerCertificateId != null : !this.customServerCertificateId.equals(other.customServerCertificateId));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + Secret.toString((Secret)this.password).hashCode();
        return result;
    }

    @Override
    public ElasticSearchDao createIndexerInstance() {
        ElasticSearchDao esDao = new ElasticSearchDao(this.getUri(), this.username, Secret.toString((Secret)this.password));
        esDao.setMimeType(this.getMimeType());
        try {
            esDao.setCustomKeyStore(this.getCustomKeyStore());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return esDao;
    }

    private KeyStore getCustomKeyStore() {
        StandardCertificateCredentials certificateCredentials;
        KeyStore customKeyStore = null;
        if (!StringUtils.isBlank((String)this.customServerCertificateId) && (certificateCredentials = this.getCredentials(this.customServerCertificateId)) != null) {
            customKeyStore = certificateCredentials.getKeyStore();
        }
        return customKeyStore;
    }

    private StandardCertificateCredentials getCredentials(String credentials) {
        return (StandardCertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentials));
    }

    @Extension
    @Symbol(value={"elasticSearch"})
    public static class ElasticSearchDescriptor
    extends LogstashIndexer.LogstashIndexerDescriptor {
        public String getDisplayName() {
            return "Elastic Search";
        }

        @Override
        public int getDefaultPort() {
            return 0;
        }

        public ListBoxModel doFillCustomServerCertificateIdItems(@AncestorInPath Item item, @QueryParameter String customServerCertificateId) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public FormValidation doCheckUrl(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)Messages.PleaseProvideHost());
            }
            try {
                URL url = new URL(value);
                if (url.getUserInfo() != null) {
                    return FormValidation.error((String)"Please specify user and password not as part of the url.");
                }
                if (StringUtils.isBlank((String)url.getPath()) || url.getPath().trim().matches("^\\/+$")) {
                    return FormValidation.warning((String)"Elastic Search requires a key to be able to index the logs.");
                }
                url.toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMimeType(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.ValueIsRequired());
            }
            try {
                new MimeType(value);
            }
            catch (MimeTypeParseException e) {
                return FormValidation.error((String)Messages.ProvideValidMimeType());
            }
            return FormValidation.ok();
        }
    }
}

