/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.commands;

import hudson.Extension;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import org.jenkinsci.plugins.commands.Messages;
import org.jenkinsci.plugins.commands.SLC;
import org.jenkinsci.plugins.commands.ShowLogCommand;
import org.jenkinsci.plugins.commands.WrongBuildNumberException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

@Extension(optional=true)
public class ShowLogIMCommand
extends AbstractTextSendingCommand {
    private CmdLineParser parser;

    protected String getReply(Bot bot, Sender sender, String[] args) {
        ShowLogCommand sCommand = new ShowLogCommand();
        this.parser = new CmdLineParser((Object)sCommand);
        String[] argsToParser = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        try {
            this.parser.parseArgument(argsToParser);
        }
        catch (CmdLineException e) {
            return sender.toString() + ": " + e.getMessage() + "\n" + this.getUsageString();
        }
        try {
            return SLC.showLog(sCommand.getJob(), sCommand.getBuildNumber(), sCommand.getMaxLines());
        }
        catch (WrongBuildNumberException e) {
            return sender.toString() + ": " + e.getMessage() + "\n" + this.getUsageString();
        }
    }

    private String getUsageString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.parser.printSingleLineUsage((OutputStream)baos);
        try {
            return "Usage: " + this.getUsageCommandName() + " " + baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Error with UTF8-encoding when showing usage: " + e.getMessage();
        }
    }

    private String getUsageCommandName() {
        Collection<String> cNames = this.getCommandNames();
        if (cNames.size() == 1) {
            return cNames.iterator().next();
        }
        StringBuffer uCn = new StringBuffer();
        uCn.append("{");
        for (String name : cNames) {
            uCn.append(name + " | ");
        }
        String uCnRet = uCn.toString().substring(0, uCn.toString().lastIndexOf(124)) + "}";
        return uCnRet;
    }

    public Collection<String> getCommandNames() {
        return Arrays.asList("show-log", "sl");
    }

    public String getHelp() {
        return " <job> [-bNumber (-b) <N>] [-nLines (-n) <N>] - " + Messages.showLogCommand();
    }
}

