/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;

public class Workspace {
    private final FilePath slaveWorkspacePath;
    private final String logId;
    private final FilePath slaveZIPFilePath;
    private final FilePath slavePDFFilePath;
    private final FilePath slaveMHTFilePath;
    private final FilePath masterZIPFilePath;
    private final FilePath masterPDFFilePath;
    private final FilePath masterMHTFilePath;
    private final FilePath slaveErrorFilePath;
    private final FilePath masterLogDirectory;

    public Workspace(Run<?, ?> run, FilePath filePath) throws IOException, InterruptedException {
        this.slaveWorkspacePath = this.getSlaveWorkspace(filePath);
        this.logId = Long.toString(System.currentTimeMillis() % 10000000L);
        String zipName = this.logId + ".zip";
        String mhtName = this.logId + ".mht";
        String pdfName = this.logId + ".pdf";
        this.slaveZIPFilePath = new FilePath(this.slaveWorkspacePath, zipName);
        this.slavePDFFilePath = new FilePath(this.slaveWorkspacePath, pdfName);
        this.slaveMHTFilePath = new FilePath(this.slaveWorkspacePath, mhtName);
        this.masterLogDirectory = this.getMasterLogDirectory(run);
        this.masterZIPFilePath = new FilePath(this.masterLogDirectory, zipName);
        this.masterPDFFilePath = new FilePath(this.masterLogDirectory, pdfName);
        this.masterMHTFilePath = new FilePath(this.masterLogDirectory, mhtName);
        this.slaveErrorFilePath = new FilePath(this.slaveWorkspacePath, this.logId + ".txt");
    }

    private FilePath getMasterLogDirectory(Run<?, ?> run) throws IOException, InterruptedException {
        String buildDir = run.getRootDir().getAbsolutePath();
        FilePath masterLogDirectory = new FilePath(new File(buildDir + File.separator + "lcreports"));
        masterLogDirectory.mkdirs();
        return masterLogDirectory;
    }

    private FilePath getSlaveWorkspace(FilePath filePath) throws IOException, InterruptedException {
        if (filePath == null) {
            throw new IOException(Messages.LCTestBuilder_WorkspaceNotSpecified());
        }
        filePath.mkdirs();
        return filePath.absolutize();
    }

    public FilePath getSlaveWorkspacePath() {
        return this.slaveWorkspacePath;
    }

    public String getLogId() {
        return this.logId;
    }

    public FilePath getSlaveZIPFilePath() {
        return this.slaveZIPFilePath;
    }

    public FilePath getSlavePDFFilePath() {
        return this.slavePDFFilePath;
    }

    public FilePath getSlaveMHTFilePath() {
        return this.slaveMHTFilePath;
    }

    public FilePath getMasterZIPFilePath() {
        return this.masterZIPFilePath;
    }

    public FilePath getMasterPDFFilePath() {
        return this.masterPDFFilePath;
    }

    public FilePath getMasterMHTFilePath() {
        return this.masterMHTFilePath;
    }

    public FilePath getSlaveErrorFilePath() {
        return this.slaveErrorFilePath;
    }

    public FilePath getMasterLogDirectory() {
        return this.masterLogDirectory;
    }
}

