/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.LCDynamicReportAction;
import com.smartbear.jenkins.plugins.loadcomplete.LCReportAction;
import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class LCSummaryAction
implements Action {
    private final Run<?, ?> run;
    private LinkedHashMap<String, LCReportAction> reports = new LinkedHashMap();
    private ArrayList<LCReportAction> reportsOrder = new ArrayList();
    private final LCDynamicReportAction dynamic;

    LCSummaryAction(Run<?, ?> run) {
        this.run = run;
        String buildDir = run.getRootDir().getAbsolutePath();
        String reportsPath = buildDir + File.separator + "lcreports" + File.separator;
        this.dynamic = new LCDynamicReportAction(reportsPath);
    }

    public String getIconFileName() {
        return "/plugin/loadcomplete/images/lc-48x48.png";
    }

    public String getDisplayName() {
        return Messages.TcSummaryAction_DisplayName();
    }

    public String getUrlName() {
        return "loadcomplete";
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void addReport(LCReportAction report) {
        if (!this.reports.containsValue(report)) {
            report.setParent(this);
            this.reports.put(report.getId(), report);
            this.reportsOrder.add(report);
        }
    }

    @Exported(name="reports", inline=true)
    public ArrayList<LCReportAction> getReportsOrder() {
        return this.reportsOrder;
    }

    public HashMap<String, LCReportAction> getReports() {
        return this.reports;
    }

    public LCReportAction getNextReport(LCReportAction report) {
        if (report == null || !this.reportsOrder.contains(report)) {
            return null;
        }
        int index = this.reportsOrder.indexOf(report);
        if (index + 1 >= this.reportsOrder.size()) {
            return null;
        }
        return this.reportsOrder.get(index + 1);
    }

    public LCReportAction getPreviousReport(LCReportAction report) {
        if (report == null || !this.reportsOrder.contains(report)) {
            return null;
        }
        int index = this.reportsOrder.indexOf(report);
        if (index <= 0) {
            return null;
        }
        return this.reportsOrder.get(index - 1);
    }

    public LCDynamicReportAction getDynamic() {
        return this.dynamic;
    }

    public String getPluginUrl() {
        return "loadcomplete";
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

