/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.LCLogInfo;
import com.smartbear.jenkins.plugins.loadcomplete.LCSummaryAction;
import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class LCReportAction
implements Action,
Serializable {
    private final Run<?, ?> run;
    private final String id;
    private final String testName;
    private final String agent;
    private String zipLogFileName = "";
    private String pdfLogFileName = "";
    private String mhtLogFileName = "";
    private int exitCode = 0;
    private boolean result = true;
    private String error = "";
    private LCLogInfo logInfo = null;
    private transient LCSummaryAction parent = null;

    public LCReportAction(Run<?, ?> run, String id, String testName, String agent) {
        this.id = id;
        this.testName = testName;
        this.agent = agent;
        this.run = run;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return this.testName;
    }

    public String getUrlName() {
        return null;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getId() {
        return this.id;
    }

    @Exported(name="testName")
    public String getTestName() {
        return this.testName;
    }

    @Exported(name="agent")
    public String getAgent() {
        return this.agent;
    }

    @Exported(name="url")
    public String getUrl() {
        return Jenkins.getInstance().getRootUrl() + this.run.getUrl() + "loadcomplete" + "/reports/" + this.id;
    }

    public String getZipLogFileName() {
        return this.zipLogFileName;
    }

    public void setZipLogFileName(String zipLogFileName) {
        this.zipLogFileName = zipLogFileName;
    }

    public String getPdfLogFileName() {
        return this.pdfLogFileName;
    }

    public void setPdfLogFileName(String pdfLogFileName) {
        this.pdfLogFileName = pdfLogFileName;
    }

    public String getMhtLogFileName() {
        return this.mhtLogFileName;
    }

    public void setMhtLogFileName(String mhtLogFileName) {
        this.mhtLogFileName = mhtLogFileName;
    }

    @Exported(name="exitCode")
    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Exported(name="success")
    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    @Exported(name="error")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @Exported(name="details", inline=true)
    public LCLogInfo getLogInfo() {
        return this.logInfo;
    }

    public void setLogInfo(LCLogInfo logInfo) {
        this.logInfo = logInfo;
    }

    public LCSummaryAction getParent() {
        return this.parent;
    }

    public void setParent(LCSummaryAction parent) {
        this.parent = parent;
    }

    public boolean hasInfo() {
        return this.zipLogFileName != null && !this.zipLogFileName.isEmpty() || this.error != null && !this.error.isEmpty();
    }

    public String getNoInfoMessage(String url) {
        return String.format(Messages.LCTestBuilder_NoInfo(), url);
    }

    public boolean hasZIPReport() {
        return this.zipLogFileName != null && !this.zipLogFileName.isEmpty();
    }

    public boolean hasPDFReport() {
        return this.pdfLogFileName != null && !this.pdfLogFileName.isEmpty();
    }

    public boolean hasMHTReport() {
        return this.mhtLogFileName != null && !this.mhtLogFileName.isEmpty();
    }
}

