/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.LCInstallation;
import com.smartbear.jenkins.plugins.loadcomplete.LCLog;
import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.jna.JnaException;
import hudson.util.jna.RegistryKey;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.remoting.RoleChecker;

public class LCInstallationsScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int REGISTRY_KEY_WOW64_32KEY = 512;
    private static final int REGISTRY_KEY_READ = 131097;
    private final VirtualChannel channel;
    private final TaskListener listener;

    public LCInstallationsScanner(VirtualChannel channel, TaskListener listener) {
        this.channel = channel;
        this.listener = listener;
    }

    public List<LCInstallation> getInstallations() {
        List result = null;
        try {
            result = (List)this.channel.call((Callable)new ScannerCallable());
        }
        catch (Exception e) {
            LCLog.error(this.listener, Messages.LCTestBuilder_RemoteCallingFailed(), e.getCause().getMessage());
        }
        return result != null ? result : new LinkedList();
    }

    public LCInstallation findInstallation(List<LCInstallation> installations, String executorVersion) {
        LCInstallation result = null;
        for (LCInstallation installation : installations) {
            if (!executorVersion.equals("any") && installation.compareVersion(executorVersion, true) != 0) continue;
            if (result == null) {
                result = installation;
                continue;
            }
            if (installation.compareVersion(result.getVersion(), false) <= 0) continue;
            result = installation;
        }
        return result;
    }

    private static class ScannerCallable
    implements Callable<List<LCInstallation>, Exception>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String registryKey = "SOFTWARE\\SmartBear\\";

        ScannerCallable() {
        }

        public List<LCInstallation> call() throws Exception {
            ArrayList<LCInstallation> result = new ArrayList<LCInstallation>();
            this.scanForInstallations(result, "LoadComplete");
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanForInstallations(List<LCInstallation> result, String executor) {
            block14: {
                String key = registryKey + executor + "\\";
                RegistryKey executorKey = null;
                try {
                    executorKey = RegistryKey.LOCAL_MACHINE.open(key, 131609);
                    Collection installKeys = executorKey.getSubKeys();
                    if (installKeys == null || installKeys.size() <= 0) break block14;
                    for (String versionKey : installKeys) {
                        if (!versionKey.matches("^[0-9]{1,3}([.][0-9]{1,5})+$")) continue;
                        RegistryKey setupKey = null;
                        try {
                            setupKey = executorKey.open(versionKey + "\\Setup\\", 131609);
                            String path = setupKey.getStringValue("Product path");
                            String version = setupKey.getStringValue("Version");
                            if (version == null || !version.matches("^[0-9]{1,3}([.][0-9]{1,5})+$") || path == null || path.isEmpty()) continue;
                            String executorPath = path + "x64\\bin\\" + executor + ".exe";
                            if (new File(executorPath).exists()) {
                                result.add(new LCInstallation(executorPath, version));
                                continue;
                            }
                            executorPath = path + "bin\\" + executor + ".exe";
                            if (!new File(executorPath).exists()) continue;
                            result.add(new LCInstallation(executorPath, version));
                        }
                        catch (JnaException jnaException) {}
                        continue;
                        finally {
                            if (setupKey == null) continue;
                            setupKey.dispose();
                        }
                    }
                }
                catch (JnaException jnaException) {
                }
                finally {
                    if (executorKey != null) {
                        executorKey.dispose();
                    }
                }
            }
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

