/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import java.io.Serializable;

public class LCInstallation
implements Serializable {
    private static final int VERSION_PARTS = 3;
    private final String executorPath;
    private final String version;

    public LCInstallation(String executorPath, String version) {
        this.executorPath = executorPath;
        this.version = version;
    }

    public String getExecutorPath() {
        return this.executorPath;
    }

    public String getVersion() {
        return this.version;
    }

    public int compareVersion(String anotherVersion, boolean majorOnly) {
        int i;
        int[] selfVersionParts = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            selfVersionParts[i2] = 0;
        }
        int[] anotherVersionParts = new int[3];
        for (int i3 = 0; i3 < 3; ++i3) {
            anotherVersionParts[i3] = 0;
        }
        String[] selfSplit = this.version.split("[.]");
        for (int i4 = 0; i4 < Math.min(3, selfSplit.length); ++i4) {
            selfVersionParts[i4] = Integer.parseInt(selfSplit[i4]);
        }
        String[] anotherSplit = anotherVersion.split("[.]");
        for (i = 0; i < Math.min(3, anotherSplit.length); ++i) {
            anotherVersionParts[i] = Integer.parseInt(anotherSplit[i]);
        }
        for (i = 0; i < (majorOnly ? 1 : 3); ++i) {
            if (selfVersionParts[i] > anotherVersionParts[i]) {
                return 1;
            }
            if (selfVersionParts[i] >= anotherVersionParts[i]) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.format(Messages.LCTestBuilder_InstallationString(), this.getVersion(), this.getExecutorPath());
    }
}

