/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import hudson.model.Action;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class LCDynamicReportAction
implements Action {
    private static final String DOWNLOAD_FILE_NAME = "Test";
    private final String baseReportsPath;

    LCDynamicReportAction(String baseReportsPath) {
        this.baseReportsPath = baseReportsPath;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!req.getMethod().equals("GET")) {
            rsp.sendError(405);
            return;
        }
        String path = req.getRestOfPath();
        if (path.length() == 0 || path.contains("..") || path.length() < 1) {
            rsp.sendError(400);
            return;
        }
        String[] parts = (path = path.substring(1)).split("/");
        if (parts.length == 0) {
            rsp.sendError(400);
            return;
        }
        String ext = null;
        if (parts.length == 1 && parts[0].endsWith(".zip")) {
            ext = ".zip";
        } else if (parts.length == 1 && parts[0].endsWith(".pdf")) {
            ext = ".pdf";
        } else if (parts.length == 1 && parts[0].endsWith(".mht")) {
            ext = ".mht";
        }
        if (ext != null) {
            String requestedFilePath = this.baseReportsPath + parts[0];
            File file = new File(requestedFilePath);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                rsp.sendError(404);
                return;
            }
            try (FileInputStream fis = null;){
                fis = new FileInputStream(file);
                rsp.setHeader("Content-Disposition", "filename=\"Test" + ext + "\"");
                rsp.serveFile(req, (InputStream)fis, file.lastModified(), 0L, file.length(), "mime-type:application/force-download");
            }
        } else {
            String archiveName = parts[0] + ".zip";
            File logFile = new File(this.baseReportsPath, archiveName);
            if (!logFile.exists() || !logFile.isFile()) {
                rsp.sendError(404);
                return;
            }
            String entryName = parts.length == 1 ? "index.html" : path.substring(parts[0].length() + 1);
            ZipFile archive = null;
            InputStream inputStream = null;
            try {
                archive = new ZipFile(logFile);
                ZipEntry targetEntry = this.searchEntry(archive, entryName);
                if (targetEntry == null) {
                    rsp.sendError(404);
                    return;
                }
                inputStream = archive.getInputStream(targetEntry);
                if (entryName.startsWith("data/report.data")) {
                    rsp.serveFile(req, inputStream, targetEntry.getTime(), 0L, targetEntry.getSize(), "report_data.js");
                } else {
                    rsp.serveFile(req, inputStream, targetEntry.getTime(), 0L, targetEntry.getSize(), targetEntry.getName());
                }
            }
            catch (Exception e) {
                rsp.sendError(500);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (archive != null) {
                    archive.close();
                }
            }
        }
    }

    private ZipEntry searchEntry(ZipFile archive, String entryName) {
        ZipEntry targetEntry = archive.getEntry(entryName);
        if (targetEntry == null) {
            entryName = entryName.replace("/", "\\");
            targetEntry = archive.getEntry(entryName);
        }
        if (targetEntry == null) {
            Enumeration<? extends ZipEntry> entries = archive.entries();
            entryName = entryName.toUpperCase();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String currentEntryName = entry.getName().toUpperCase();
                if (!currentEntryName.equals(entryName) && !currentEntryName.replace("/", "\\").equals(entryName)) continue;
                return entry;
            }
        }
        return targetEntry;
    }
}

