/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.install;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.liquibase.install.LiquibaseInstaller;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class LiquibaseInstallation
extends ToolInstallation
implements NodeSpecific<LiquibaseInstallation>,
EnvironmentSpecific<LiquibaseInstallation> {
    private static final long serialVersionUID = 1L;
    private String liquibaseHome;
    private String databaseDriverUrl;

    @DataBoundConstructor
    public LiquibaseInstallation(String name, String home, String databaseDriverUrl, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)"liquibase"), properties);
        this.liquibaseHome = home;
        this.databaseDriverUrl = databaseDriverUrl;
    }

    public LiquibaseInstallation forEnvironment(EnvVars environment) {
        return new LiquibaseInstallation(this.getName(), environment.expand(this.liquibaseHome), environment.expand(this.databaseDriverUrl), this.getProperties().toList());
    }

    public LiquibaseInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new LiquibaseInstallation(this.getName(), this.translateFor(node, log), this.databaseDriverUrl, this.getProperties().toList());
    }

    public String getHome() {
        String resolvedHome = this.liquibaseHome != null ? this.liquibaseHome : super.getHome();
        return resolvedHome;
    }

    public File getLiquibaseJar() {
        return new File(this.liquibaseHome, "liquibase.jar");
    }

    public boolean isValidLiquibaseHome() {
        File liquibaseJar = this.getLiquibaseJar();
        return liquibaseJar != null && liquibaseJar.exists();
    }

    public String getDatabaseDriverUrl() {
        return this.databaseDriverUrl;
    }

    @DataBoundSetter
    public void setDatabaseDriverUrl(String databaseDriverUrl) {
        this.databaseDriverUrl = databaseDriverUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<LiquibaseInstallation> {
        private LiquibaseInstallation[] installations = new LiquibaseInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Liquibase";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new LiquibaseInstaller(null));
        }

        public LiquibaseInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(LiquibaseInstallation ... installations) {
            this.installations = installations;
            this.save();
        }
    }
}

