/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.common;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseBuilder;
import org.jenkinsci.plugins.liquibase.common.LiquibaseProperty;
import org.jenkinsci.plugins.liquibase.exception.LiquibaseRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesAssembler.class);
    private static final String DEFAULT_JDBC_URL = "jdbc:h2:mem:builder-db";

    public static Properties createLiquibaseProperties(AbstractLiquibaseBuilder liquibaseBuilder, Run<?, ?> build, Map environment, FilePath workspace) throws IOException, InterruptedException {
        Properties properties = new Properties();
        PropertiesAssembler.assembleDefaults(properties);
        PropertiesAssembler.assembleFromPropertiesFile(liquibaseBuilder, build, environment, workspace, properties);
        PropertiesAssembler.assembleFromProjectConfiguration(liquibaseBuilder, properties, environment, build);
        return properties;
    }

    private static void assembleFromPropertiesFile(AbstractLiquibaseBuilder liquibaseBuilder, Run<?, ?> build, Map environment, FilePath workspace, Properties properties) {
        String propertiesPath = build instanceof AbstractBuild ? Util.replaceMacro((String)liquibaseBuilder.getLiquibasePropertiesPath(), (Map)environment) : liquibaseBuilder.getLiquibasePropertiesPath();
        PropertiesAssembler.assembleFromPropertiesFile(properties, propertiesPath, workspace);
    }

    protected static void assembleFromProjectConfiguration(AbstractLiquibaseBuilder liquibaseBuilder, Properties properties, Map environment, Run<?, ?> build) throws IOException, InterruptedException {
        StandardUsernamePasswordCredentials credentials;
        if (!Strings.isNullOrEmpty((String)liquibaseBuilder.getCredentialsId()) && (credentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)liquibaseBuilder.getCredentialsId(), StandardUsernamePasswordCredentials.class, build, (List)Lists.newArrayList())) != null) {
            String username = credentials.getUsername();
            if (!Strings.isNullOrEmpty((String)username)) {
                PropertiesAssembler.setProperty(properties, LiquibaseProperty.USERNAME, username);
            }
            PropertiesAssembler.setProperty(properties, LiquibaseProperty.PASSWORD, credentials.getPassword().getPlainText());
        }
        PropertiesAssembler.addPropertyIfDefined(properties, LiquibaseProperty.CHANGELOG_FILE, liquibaseBuilder.getChangeLogFile(), environment, build);
        PropertiesAssembler.addPropertyIfDefined(properties, LiquibaseProperty.URL, liquibaseBuilder.getUrl(), environment, build);
        PropertiesAssembler.addPropertyIfDefined(properties, LiquibaseProperty.CHANGELOG_FILE, liquibaseBuilder.getChangeLogFile(), environment, build);
        PropertiesAssembler.addPropertyIfDefined(properties, LiquibaseProperty.LABELS, liquibaseBuilder.getLabels(), environment, build);
        PropertiesAssembler.addPropertyIfDefined(properties, LiquibaseProperty.CONTEXTS, liquibaseBuilder.getContexts(), environment, build);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void assembleFromPropertiesFile(Properties properties, String liquibasePropertiesPath, FilePath workspace) {
        if (Strings.isNullOrEmpty((String)liquibasePropertiesPath)) return;
        if (workspace == null) throw new LiquibaseRuntimeException("Project workspace was found to be null when attempting to load liquibase properties file at '" + liquibasePropertiesPath + '.');
        InputStreamReader streamReader = null;
        try {
            FilePath liquibaseProperties = workspace.child(liquibasePropertiesPath);
            streamReader = new InputStreamReader(liquibaseProperties.read(), StandardCharsets.UTF_8);
            properties.load(streamReader);
        }
        catch (IOException e) {
            try {
                throw new LiquibaseRuntimeException("Unable to load properties file at '" + liquibasePropertiesPath + "'", e);
                catch (InterruptedException e2) {
                    throw new LiquibaseRuntimeException("Unable to load properties file at '" + liquibasePropertiesPath + "'", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(streamReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)streamReader);
    }

    private static void assembleDefaults(Properties properties) {
        PropertiesAssembler.setProperty(properties, LiquibaseProperty.URL, DEFAULT_JDBC_URL);
    }

    private static void setProperty(Properties properties, LiquibaseProperty liquibaseProperty, String value) {
        properties.setProperty(liquibaseProperty.propertyName(), value);
    }

    protected static void addPropertyIfDefined(Properties properties, LiquibaseProperty liquibaseProperty, String value, Map environment, Run<?, ?> build) {
        if (!Strings.isNullOrEmpty((String)value)) {
            String resolvedValue = build instanceof AbstractBuild ? Util.replaceMacro((String)value, (Map)environment) : value;
            properties.setProperty(liquibaseProperty.propertyName(), resolvedValue);
        }
    }
}

