/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.builder;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseBuilder;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TagBuilder
extends AbstractLiquibaseBuilder {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String tag;

    @DataBoundConstructor
    public TagBuilder() {
    }

    @Override
    protected void addCommandAndArguments(ArgumentListBuilder cliCommand, Properties configProperties, Run<?, ?> build, EnvVars environment, TaskListener listener) {
        String tagString = this.getTag();
        if (tagString == null || tagString.trim().equals("")) {
            tagString = build.getParent().getName() + "-" + build.getNumber();
        }
        cliCommand.add(new String[]{"tag", Util.replaceMacro((String)tagString, (Map)environment)});
    }

    @Override
    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getTag() {
        return this.tag;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractLiquibaseDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public DescriptorImpl(Class<? extends TagBuilder> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Liquibase: Tag Database";
        }
    }
}

