/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.builder;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseBuilder;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseDescriptor;
import org.jenkinsci.plugins.liquibase.exception.LiquibaseRuntimeException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RollbackBuilder
extends AbstractLiquibaseBuilder {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private String rollbackType;
    protected String numberOfChangesetsToRollback;
    private String rollbackLastHours;
    private String rollbackToTag;
    private String rollbackToDate;
    private transient SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @DataBoundConstructor
    public RollbackBuilder() {
    }

    @Override
    protected void addCommandAndArguments(ArgumentListBuilder cliCommand, Properties configProperties, Run<?, ?> build, EnvVars environment, TaskListener listener) throws IOException {
        try {
            RollbackStrategy rollbackStrategy = RollbackStrategy.valueOf(this.rollbackType);
            if (rollbackStrategy == RollbackStrategy.COUNT) {
                String resolvedRollbackCount = Util.replaceMacro((String)this.numberOfChangesetsToRollback, (Map)environment);
                if (resolvedRollbackCount == null) {
                    throw new LiquibaseRuntimeException("Invalid value '" + this.numberOfChangesetsToRollback + "' for rollback count.");
                }
                int rollbackCount = Integer.parseInt(resolvedRollbackCount);
                cliCommand.add(new String[]{"rollbackCount", String.valueOf(rollbackCount)});
            }
            if (rollbackStrategy == RollbackStrategy.DATE || rollbackStrategy == RollbackStrategy.RELATIVE) {
                Date targetDate = this.resolveTargetDate(rollbackStrategy, environment);
                cliCommand.add(new String[]{"rollbackDate", String.valueOf(targetDate)});
            }
            if (rollbackStrategy == RollbackStrategy.TAG) {
                String resolvedTag = Util.replaceMacro((String)this.rollbackToTag, (Map)environment);
                cliCommand.add(new String[]{"rollback", resolvedTag});
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected Date resolveTargetDate(RollbackStrategy rollbackStrategy, EnvVars environment) {
        Date now = new Date();
        return this.resolveTargetDate(rollbackStrategy, now, environment);
    }

    protected Date resolveTargetDate(RollbackStrategy rollbackStrategy, Date now, EnvVars environment) {
        Date targetDate;
        if (rollbackStrategy == RollbackStrategy.RELATIVE) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(now);
            String lastHours = Util.replaceMacro((String)this.rollbackLastHours, (Map)environment);
            if (lastHours != null) {
                instance.add(10, 0 - Integer.parseInt(lastHours));
            }
            targetDate = instance.getTime();
        } else {
            String rollbackDate = Util.replaceMacro((String)this.rollbackToDate, (Map)environment);
            try {
                targetDate = this.simpleDateFormat.parse(rollbackDate);
            }
            catch (ParseException e) {
                throw new LiquibaseRuntimeException("Invalid value for rollback to date value:" + rollbackDate, e);
            }
        }
        return targetDate;
    }

    @Override
    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getNumberOfChangesetsToRollback() {
        return this.numberOfChangesetsToRollback;
    }

    @DataBoundSetter
    public void setNumberOfChangesetsToRollback(String numberOfChangesetsToRollback) {
        this.numberOfChangesetsToRollback = numberOfChangesetsToRollback;
    }

    public String getRollbackToTag() {
        return this.rollbackToTag;
    }

    @DataBoundSetter
    public void setRollbackToTag(String rollbackToTag) {
        this.rollbackToTag = rollbackToTag;
    }

    public String getRollbackToDate() {
        return this.rollbackToDate;
    }

    @DataBoundSetter
    public void setRollbackToDate(String rollbackToDate) {
        this.rollbackToDate = rollbackToDate;
    }

    public String getRollbackType() {
        return this.rollbackType;
    }

    @DataBoundSetter
    public void setRollbackType(String rollbackType) {
        this.rollbackType = rollbackType;
    }

    public String getRollbackLastHours() {
        return this.rollbackLastHours;
    }

    @DataBoundSetter
    public void setRollbackLastHours(String rollbackLastHours) {
        this.rollbackLastHours = rollbackLastHours;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractLiquibaseDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public DescriptorImpl(Class<? extends RollbackBuilder> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Liquibase: Roll Back Changes";
        }
    }

    public static enum RollbackStrategy {
        TAG,
        DATE,
        RELATIVE,
        COUNT;

    }
}

