/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.builder;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Properties;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseBuilder;
import org.jenkinsci.plugins.liquibase.builder.AbstractLiquibaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RawCliBuilder
extends AbstractLiquibaseBuilder {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String commandArguments;

    @DataBoundConstructor
    public RawCliBuilder() {
    }

    @Override
    protected void addCommandAndArguments(ArgumentListBuilder cliCommand, Properties configProperties, Run<?, ?> build, EnvVars environment, TaskListener listener) throws IOException {
        if (this.commandArguments == null || this.commandArguments.trim().equals("")) {
            throw new AbortException("No command line specified in '" + this.getDescriptor().getDisplayName() + "' configuration");
        }
        cliCommand.add(environment.expand(this.commandArguments).replaceAll("\r\n", " ").replaceAll("\n", " ").split(" "));
    }

    @Override
    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getCommandArguments() {
        return this.commandArguments;
    }

    @DataBoundSetter
    public void setCommandArguments(String commandArguments) {
        this.commandArguments = commandArguments;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractLiquibaseDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public DescriptorImpl(Class<? extends RawCliBuilder> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Liquibase: CLI Command";
        }
    }
}

