/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.liquibase.builder;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.liquibase.common.LiquibaseProperty;
import org.jenkinsci.plugins.liquibase.common.PropertiesAssembler;
import org.jenkinsci.plugins.liquibase.install.LiquibaseInstallation;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLiquibaseBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLiquibaseBuilder.class);
    protected String installationName;
    protected String changeLogFile;
    protected String url;
    protected String contexts;
    protected String liquibasePropertiesPath;
    protected String labels;
    private String changeLogParameters;
    private String resourceDirectories;
    private String credentialsId;
    @Deprecated
    protected transient String username;
    @Deprecated
    protected transient String password;

    public LiquibaseInstallation getInstallation(EnvVars env, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        LiquibaseInstallation.DescriptorImpl installDescriptor;
        LiquibaseInstallation foundInstallation = null;
        if (this.installationName != null && (installDescriptor = (LiquibaseInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(LiquibaseInstallation.DescriptorImpl.class))) != null) {
            for (LiquibaseInstallation i : installDescriptor.getInstallations()) {
                if (!this.installationName.equals(i.getName())) continue;
                foundInstallation = i;
                break;
            }
        }
        if (foundInstallation == null) {
            return null;
        }
        Computer computer = workspace.toComputer();
        if (computer == null) {
            return null;
        }
        Node node = computer.getNode();
        if (node == null) {
            return null;
        }
        LiquibaseInstallation returnInstaller = foundInstallation.forNode(node, listener);
        returnInstaller = returnInstaller.forEnvironment(env);
        return returnInstaller;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    @DataBoundSetter
    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    protected Object readResolve() {
        return this;
    }

    public abstract Descriptor<Builder> getDescriptor();

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("\n\nRunning " + this.getDescriptor().getDisplayName() + "....");
        EnvVars environment = build.getEnvironment(listener);
        Properties configProperties = PropertiesAssembler.createLiquibaseProperties(this, build, (Map)environment, workspace);
        LiquibaseInstallation installation = this.getInstallation(environment, listener, workspace);
        if (installation == null) {
            listener.fatalError("Liquibase installation was not found.");
            build.setResult(Result.NOT_BUILT);
            return;
        }
        log.println("Liquibase home: " + installation.getHome());
        if (!installation.isValidLiquibaseHome()) {
            listener.fatalError("Liquibase installation " + installation.getHome() + " is not a valid Liquibase install");
            build.setResult(Result.NOT_BUILT);
            return;
        }
        if (!Strings.isNullOrEmpty((String)installation.getDatabaseDriverUrl())) {
            Iterable urls = Splitter.on((String)",").trimResults().split((CharSequence)installation.getDatabaseDriverUrl());
            for (String url : urls) {
                String filename = url.substring(installation.getDatabaseDriverUrl().lastIndexOf("/") + 1);
                File localJar = new File(installation.getHome(), "lib/" + filename);
                if (localJar.exists()) continue;
                log.println("Downloading " + url + " to " + localJar);
                URL downloadUrl = new URL(url);
                new FilePath(localJar).copyFrom(downloadUrl);
            }
        }
        String liquibaseCmd = Functions.isWindows() ? installation.getHome() + "\\liquibase.bat" : installation.getHome() + "/liquibase";
        ArgumentListBuilder cliCommand = new ArgumentListBuilder(new String[]{liquibaseCmd});
        this.addGlobalArguments(cliCommand, configProperties, build, environment, listener);
        this.addCommandAndArguments(cliCommand, configProperties, build, environment, listener);
        int exitStatus = launcher.launch().cmds(cliCommand).stdout(listener).join();
        boolean result = this.didErrorsOccur(build, exitStatus);
        if (!result) {
            throw new AbortException("Liquibase failed due to errors.");
        }
    }

    protected abstract void addCommandAndArguments(ArgumentListBuilder var1, Properties var2, Run<?, ?> var3, EnvVars var4, TaskListener var5) throws IOException;

    private boolean didErrorsOccur(Run<?, ?> build, int exitStatus) throws IOException {
        boolean result = true;
        if (exitStatus != 0) {
            result = false;
        }
        return result;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    @DataBoundSetter
    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getContexts() {
        return this.contexts;
    }

    @DataBoundSetter
    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLiquibasePropertiesPath() {
        return this.liquibasePropertiesPath;
    }

    @DataBoundSetter
    public void setLiquibasePropertiesPath(String liquibasePropertiesPath) {
        this.liquibasePropertiesPath = liquibasePropertiesPath;
    }

    public String getChangeLogParameters() {
        return this.changeLogParameters;
    }

    @DataBoundSetter
    public void setChangeLogParameters(String changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public String getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getResourceDirectories() {
        return this.resourceDirectories;
    }

    @DataBoundSetter
    public void setResourceDirectories(String resourceDirectories) {
        this.resourceDirectories = resourceDirectories;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    public void clearLegacyCredentials() {
        this.username = null;
        this.password = null;
    }

    public boolean hasLegacyCredentials() {
        return !Strings.isNullOrEmpty((String)this.username);
    }

    protected String getProperty(Properties configProperties, LiquibaseProperty property) {
        return configProperties.getProperty(property.propertyName());
    }

    protected void addArgument(ArgumentListBuilder cliCommand, String key, String value) {
        if (value != null && !value.equals("")) {
            cliCommand.addKeyValuePair("--", key, value, false);
        }
    }

    protected void addArgument(ArgumentListBuilder cliCommand, String key, String value, boolean maskValue) {
        cliCommand.addKeyValuePair("--", key, value, maskValue);
    }

    protected void addGlobalArguments(ArgumentListBuilder cliCommand, Properties configProperties, Run<?, ?> build, EnvVars environment, TaskListener listener) throws IOException, InterruptedException {
        String classpath = Util.replaceMacro((String)this.getResourceDirectories(), (Map)environment);
        if (classpath != null) {
            this.addArgument(cliCommand, "classpath", classpath.replaceAll("\\s*,\\s*", ";"));
        }
        this.addArgument(cliCommand, "defaultsFile", Util.replaceMacro((String)this.getLiquibasePropertiesPath(), (Map)environment));
        this.addArgument(cliCommand, "changeLogFile", Util.replaceMacro((String)this.getChangeLogFile(), (Map)environment));
        this.addArgument(cliCommand, "url", Util.replaceMacro((String)this.getUrl(), (Map)environment));
        this.addArgument(cliCommand, "username", this.getProperty(configProperties, LiquibaseProperty.USERNAME));
        this.addArgument(cliCommand, "password", this.getProperty(configProperties, LiquibaseProperty.PASSWORD), true);
        this.addArgument(cliCommand, "contexts", Util.replaceMacro((String)this.getContexts(), (Map)environment));
        this.addArgument(cliCommand, "labels", Util.replaceMacro((String)this.getLabels(), (Map)environment));
    }
}

