/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.linkcolumn;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class LinkColumn
extends ListViewColumn {
    private String columnName;
    private String linkText;
    private String linkUrl;
    private boolean openNewWindow;

    @DataBoundConstructor
    public LinkColumn(String columnName, String linkText, String linkUrl, boolean openNewWindow) {
        this.columnName = columnName;
        this.linkText = linkText;
        this.linkUrl = linkUrl;
        this.openNewWindow = openNewWindow;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public boolean isOpenNewWindow() {
        return this.openNewWindow;
    }

    public String getTokenizedLinkText(Job<?, ?> job) {
        return this.tokenize(this.linkText, job);
    }

    public String getTokenizedLinkUrl(Job<?, ?> job) {
        return this.tokenize(this.linkUrl, job);
    }

    public String getLinkTarget() {
        return this.openNewWindow ? "_blank" : "_self";
    }

    private String tokenize(String value, Job<?, ?> job) {
        String rootUrl = "null";
        String jobName = "null";
        String jobUrl = "null";
        String buildNumber = "null";
        String buildUrl = "null";
        String buildStatus = "null";
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            rootUrl = instance.getRootUrl();
            jobName = job.getName();
            jobUrl = rootUrl + job.getShortUrl();
            Run lastBuild = job.getLastBuild();
            if (lastBuild != null) {
                buildNumber = String.valueOf(lastBuild.getNumber());
                buildUrl = jobUrl + buildNumber + "/";
                Result result = lastBuild.getResult();
                if (result != null) {
                    buildStatus = result.toString();
                }
            }
        }
        EnvVars envVars = new EnvVars();
        envVars.put("ROOT_URL", rootUrl);
        envVars.put("JOB_NAME", jobName);
        envVars.put("JOB_URL", jobUrl);
        envVars.put("BUILD_NUMBER", buildNumber);
        envVars.put("BUILD_URL", buildUrl);
        envVars.put("BUILD_STATUS", buildStatus);
        return envVars.expand(value);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public DescriptorImpl() {
            Items.XSTREAM2.addCompatibilityAlias("hudson.views.LinkColumn", LinkColumn.class);
        }

        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return "Custom Link";
        }

        public String getHelpFile() {
            return "/plugin/link-column/link-column.html";
        }
    }
}

