/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.GeneralizedTime;
import hudson.security.LDAPSecurityRealm;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jenkins.security.plugins.ldap.Messages;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;

final class UserAttributesHelper {
    private static final String ATTR_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String ATTR_ACCOUNT_EXPIRES = "accountExpires";
    private static final String ATTR_LOGIN_DISABLED = "loginDisabled";
    private static final String ATTR_ORACLE_IS_ENABLED = "orclIsEnabled";
    private static final String ATTR_PWD_ACCOUNT_LOCKED_TIME = "pwdAccountLockedTime";
    private static final String ATTR_PWD_START_TIME = "pwdStartTime";
    private static final String ATTR_PWD_END_TIME = "pwdEndTime";
    private static final String ATTR_LOGIN_EXPIRATION_TIME = "loginExpirationTime";
    private static final String ATTR_PWD_LOCKOUT = "pwdLockout";
    private static final String ATTR_LOCKED_BY_INTRUDER = "lockedByIntruder";
    private static final String ATTR_USER_ACCOUNT_CONTROL_COMPUTED = "msDS-User-Account-Control-Computed";
    private static final String ATTR_USER_ACCOUNT_DISABLED = "msDS-UserAccountDisabled";
    private static final String ATTR_USER_PASSWORD_EXPIRED = "msDS-UserPasswordExpired";
    private static final String ACCOUNT_DISABLED = "000001010000Z";
    private static final long ACCOUNT_NO_EXPIRATION = Long.MAX_VALUE;
    private static final int ADS_UF_DISABLED = 2;
    private static final int ADS_UF_LOCK_OUT = 16;
    private static final int ADS_DONT_EXPIRE_PASSWORD = 65536;
    private static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;

    public static void checkIfUserEnabled(@NonNull String username, @NonNull Attributes attributes) throws DisabledException {
        Integer uac = UserAttributesHelper.getUserAccountControl(attributes);
        if (uac != null && (uac & 2) == 2) {
            throw new DisabledException(Messages.UserDetails_Disabled(username));
        }
        String accountDisabled = UserAttributesHelper.getStringAttribute(attributes, ATTR_USER_ACCOUNT_DISABLED);
        if (accountDisabled != null) {
            if (Boolean.parseBoolean(accountDisabled)) {
                throw new DisabledException(Messages.UserDetails_Disabled(username));
            }
            return;
        }
        if (ACCOUNT_DISABLED.equals(UserAttributesHelper.getStringAttribute(attributes, ATTR_PWD_ACCOUNT_LOCKED_TIME))) {
            throw new DisabledException(Messages.UserDetails_Disabled(username));
        }
        String loginDisabled = UserAttributesHelper.getStringAttribute(attributes, ATTR_LOGIN_DISABLED);
        if (loginDisabled != null) {
            if (Boolean.parseBoolean(loginDisabled)) {
                throw new DisabledException(Messages.UserDetails_Disabled(username));
            }
            return;
        }
        String oracleIsEnabled = UserAttributesHelper.getStringAttribute(attributes, ATTR_ORACLE_IS_ENABLED);
        if (oracleIsEnabled != null && !oracleIsEnabled.equalsIgnoreCase("enabled")) {
            throw new DisabledException(Messages.UserDetails_Disabled(username));
        }
    }

    public static void checkIfAccountNonExpired(@NonNull String username, @NonNull Attributes attributes) throws AccountExpiredException {
        String accountExpirationDate = UserAttributesHelper.getStringAttribute(attributes, ATTR_ACCOUNT_EXPIRES);
        if (accountExpirationDate != null) {
            long expirationAsLong = Long.parseLong(accountExpirationDate);
            if (expirationAsLong == 0L || expirationAsLong == Long.MAX_VALUE) {
                return;
            }
            long nowIn100NsFromJan1601 = UserAttributesHelper.getWin32EpochHundredNanos();
            if (expirationAsLong > nowIn100NsFromJan1601) {
                return;
            }
            throw new AccountExpiredException(Messages.UserDetails_Expired(username, accountExpirationDate));
        }
        GeneralizedTime now = GeneralizedTime.now();
        GeneralizedTime startTime = UserAttributesHelper.getGeneralizedTimeAttribute(attributes, ATTR_PWD_START_TIME);
        if (startTime != null && startTime.isAfter(now)) {
            throw new AccountExpiredException(Messages.UserDetails_Inactive(username, startTime));
        }
        GeneralizedTime endTime = UserAttributesHelper.getGeneralizedTimeAttribute(attributes, ATTR_PWD_END_TIME);
        if (endTime != null) {
            if (endTime.isAfter(now)) {
                return;
            }
            throw new AccountExpiredException(Messages.UserDetails_Expired(username, endTime));
        }
        GeneralizedTime loginExpirationTime = UserAttributesHelper.getGeneralizedTimeAttribute(attributes, ATTR_LOGIN_EXPIRATION_TIME);
        if (loginExpirationTime != null && !loginExpirationTime.isAfter(now)) {
            throw new AccountExpiredException(Messages.UserDetails_Expired(username, loginExpirationTime));
        }
    }

    public static void checkIfCredentialsNonExpired(@NonNull String username, @NonNull Attributes attributes) throws CredentialsExpiredException {
        String passwordExpired;
        Integer uac = UserAttributesHelper.getUserAccountControl(attributes);
        if (uac != null) {
            if ((uac & 0x10000) == 65536) {
                return;
            }
            if ((uac & 0x800000) == 0x800000) {
                throw new CredentialsExpiredException(Messages.UserDetails_CredentialsExpired(username));
            }
        }
        if (Boolean.parseBoolean(passwordExpired = UserAttributesHelper.getStringAttribute(attributes, ATTR_USER_PASSWORD_EXPIRED))) {
            throw new CredentialsExpiredException(Messages.UserDetails_CredentialsExpired(username));
        }
    }

    public static void checkIfAccountNonLocked(@NonNull String username, @NonNull Attributes attributes) throws LockedException {
        Integer uac = UserAttributesHelper.getUserAccountControl(attributes);
        if (uac != null && (uac & 0x10) == 16) {
            throw new LockedException(Messages.UserDetails_Locked(username));
        }
        String lockout = UserAttributesHelper.getStringAttribute(attributes, ATTR_PWD_LOCKOUT);
        if (lockout != null) {
            if (Boolean.parseBoolean(lockout)) {
                throw new LockedException(Messages.UserDetails_Locked(username));
            }
            return;
        }
        String lockedByIntruder = UserAttributesHelper.getStringAttribute(attributes, ATTR_LOCKED_BY_INTRUDER);
        if (Boolean.parseBoolean(lockedByIntruder)) {
            throw new LockedException(Messages.UserDetails_Locked(username));
        }
    }

    private static long getWin32EpochHundredNanos() {
        GregorianCalendar win32Epoch = new GregorianCalendar(1601, 0, 1);
        Date win32EpochDate = win32Epoch.getTime();
        GregorianCalendar today = new GregorianCalendar();
        Date todayDate = today.getTime();
        long timeSinceWin32EpochInMs = todayDate.getTime() - win32EpochDate.getTime();
        long timeSinceWin32EpochInNs = TimeUnit.NANOSECONDS.convert(timeSinceWin32EpochInMs, TimeUnit.MILLISECONDS);
        return timeSinceWin32EpochInNs * 100L;
    }

    @CheckForNull
    private static Integer getUserAccountControl(@NonNull Attributes user) {
        String uac = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL);
        String computedUac = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL_COMPUTED);
        if (uac == null) {
            return computedUac == null ? null : Integer.valueOf(Integer.parseInt(computedUac));
        }
        if (computedUac == null) {
            return Integer.parseInt(uac);
        }
        return Integer.parseInt(uac) | Integer.parseInt(computedUac);
    }

    @CheckForNull
    private static GeneralizedTime getGeneralizedTimeAttribute(@NonNull Attributes user, @NonNull String attrName) {
        String timestamp = UserAttributesHelper.getStringAttribute(user, attrName);
        try {
            return timestamp == null ? null : GeneralizedTime.parse(timestamp);
        }
        catch (ParseException e) {
            LDAPSecurityRealm.LOGGER.log(Level.WARNING, e, () -> "Invalid format found parsing generalized time attribute " + attrName + " with value '" + timestamp + "'");
            return null;
        }
    }

    @CheckForNull
    private static String getStringAttribute(@NonNull Attributes user, @NonNull String attrName) {
        Attribute a = user.get(attrName);
        if (a == null || a.size() == 0) {
            return null;
        }
        try {
            Object v = a.get();
            return v == null ? null : v.toString();
        }
        catch (NamingException e) {
            return null;
        }
    }

    private UserAttributesHelper() {
        throw new UnsupportedOperationException();
    }
}

