/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapCallback;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapEntryMapper;
import org.acegisecurity.ldap.LdapTemplate;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.dao.DataAccessException;

@Restricted(value={NoExternalUse.class})
public class LDAPExtendedTemplate
extends LdapTemplate {
    public LDAPExtendedTemplate(InitialDirContextFactory dirContextFactory) {
        super(dirContextFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public Object searchForFirstEntry(@Nonnull String base, @Nonnull String filter, Object[] filterArgs, String[] attributeNames, @Nonnull LdapEntryMapper mapper) throws DataAccessException {
        try (SearchResultEnumeration searchEnum = this.searchForAllEntriesEnum(base, filter, filterArgs, attributeNames, mapper);){
            Object object = searchEnum.hasMore() ? searchEnum.next() : null;
            return object;
        }
        catch (NamingException e) {
            throw new LdapDataAccessException("Unable to get first element", (Throwable)e);
        }
    }

    @Nonnull
    public List<? extends Object> searchForAllEntries(@Nonnull String base, @Nonnull String filter, Object[] filterArgs, String[] attributeNames, @Nonnull LdapEntryMapper mapper) throws DataAccessException {
        ArrayList<Object> results = new ArrayList<Object>();
        try (SearchResultEnumeration searchEnum = this.searchForAllEntriesEnum(base, filter, filterArgs, attributeNames, mapper);){
            while (searchEnum.hasMore()) {
                results.add(searchEnum.next());
            }
        }
        catch (NamingException e) {
            throw new LdapDataAccessException("Error processing search results", (Throwable)e);
        }
        return results;
    }

    @Nonnull
    private SearchResultEnumeration searchForAllEntriesEnum(final @Nonnull String base, final @Nonnull String filter, final Object[] params, final String[] attributeNames, final @Nonnull LdapEntryMapper mapper) throws DataAccessException {
        try {
            return (SearchResultEnumeration)this.execute(new LdapCallback(){

                public SearchResultEnumeration doInDirContext(DirContext ctx) throws NamingException {
                    SearchControls controls = new SearchControls();
                    controls.setSearchScope(2);
                    controls.setReturningAttributes(attributeNames);
                    NamingEnumeration<SearchResult> searchResults = ctx.search(base, filter, params, controls);
                    return new SearchResultEnumeration(searchResults, mapper, LDAPExtendedTemplate.this.getDnSuffix(base, ctx.getNameInNamespace()));
                }
            });
        }
        catch (AuthenticationException e) {
            throw new LdapDataAccessException("Failed to search LDAP", (Throwable)e);
        }
    }

    private String getDnSuffix(String base, String nameInNamespace) {
        StringBuilder suffix = new StringBuilder();
        if (!StringUtils.isEmpty((String)base)) {
            suffix.append(",").append(base);
        }
        if (!StringUtils.isEmpty((String)nameInNamespace)) {
            suffix.append(",").append(nameInNamespace);
        }
        return suffix.toString();
    }

    private static final class SearchResultEnumeration
    implements AutoCloseable,
    NamingEnumeration {
        private final NamingEnumeration<SearchResult> searchResults;
        private final LdapEntryMapper mapper;
        private final String dnSuffix;

        public SearchResultEnumeration(NamingEnumeration<SearchResult> searchResults, LdapEntryMapper mapper, String dnSuffix) {
            this.searchResults = searchResults;
            this.mapper = mapper;
            this.dnSuffix = dnSuffix;
        }

        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.searchResults.hasMore();
        }

        public Object next() throws NamingException {
            SearchResult searchResult = this.searchResults.next();
            return this.mapper.mapAttributes(searchResult.getName() + this.dnSuffix, searchResult.getAttributes());
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                throw new LdapDataAccessException("Unable to check for more elements", (Throwable)e);
            }
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new LdapDataAccessException("Unable to get next element", (Throwable)e);
            }
        }
    }
}

