/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.MailAddressResolver;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.security.plugins.ldap.FromGroupSearchLDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import net.sf.json.JSONObject;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.ldap.LdapAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class LDAPSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final boolean FORCE_USERNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceUsernameLowercase");
    private static final boolean FORCE_GROUPNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceGroupnameLowercase");
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String server;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String rootDN;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final boolean inhibitInferRootDN;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String userSearchBase;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String userSearch;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String groupSearchBase;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String groupSearchFilter;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String groupMembershipFilter;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public LDAPGroupMembershipStrategy groupMembershipStrategy;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final String managerDN;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    private String managerPassword;
    private Secret managerPasswordSecret;
    private transient LdapTemplate ldapTemplate;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final boolean disableMailAddressResolver;
    private final CacheConfiguration cache;
    private transient Map<String, CacheEntry<LdapUserDetails>> userDetailsCache = null;
    private transient Map<String, CacheEntry<Set<String>>> groupDetailsCache = null;
    private final Map<String, String> extraEnvVars;
    private final String displayNameAttributeName;
    private final String mailAddressAttributeName;
    private final IdStrategy userIdStrategy;
    private final IdStrategy groupIdStrategy;
    private boolean disableRolePrefixing;
    private static final Logger LOGGER = Logger.getLogger(LDAPSecurityRealm.class.getName());
    public static final String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, false);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, null, null, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, Secret.fromString((String)managerPassword), inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, new FromGroupSearchLDAPGroupMembershipStrategy(groupMembershipFilter), managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipStrategy, managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName, IdStrategy.CASE_INSENSITIVE, IdStrategy.CASE_INSENSITIVE);
    }

    @DataBoundConstructor
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        this.server = server.trim();
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPasswordSecret = managerPasswordSecret;
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
            rootDN = Util.fixNull((String)this.inferRootDN(server));
        }
        this.rootDN = rootDN.trim();
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
        this.userSearch = (userSearch = Util.fixEmptyAndTrim((String)userSearch)) != null ? userSearch : "uid={0}";
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
        this.groupSearchFilter = Util.fixEmptyAndTrim((String)groupSearchFilter);
        this.groupMembershipStrategy = groupMembershipStrategy == null ? new FromGroupSearchLDAPGroupMembershipStrategy("") : groupMembershipStrategy;
        this.disableMailAddressResolver = disableMailAddressResolver;
        this.cache = cache;
        this.extraEnvVars = environmentProperties == null || environmentProperties.length == 0 ? null : EnvironmentProperty.toMap(Arrays.asList(environmentProperties));
        this.displayNameAttributeName = StringUtils.defaultString((String)Util.fixEmptyAndTrim((String)displayNameAttributeName), (String)"displayname");
        this.mailAddressAttributeName = StringUtils.defaultString((String)Util.fixEmptyAndTrim((String)mailAddressAttributeName), (String)"mail");
        this.userIdStrategy = userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : userIdStrategy;
        this.groupIdStrategy = groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : groupIdStrategy;
    }

    public boolean isDisableRolePrefixing() {
        return this.disableRolePrefixing;
    }

    @DataBoundSetter
    public void setDisableRolePrefixing(boolean disableRolePrefixing) {
        this.disableRolePrefixing = disableRolePrefixing;
    }

    private Object readResolve() {
        if (this.managerPassword != null) {
            this.managerPasswordSecret = Secret.fromString((String)Scrambler.descramble((String)this.managerPassword));
            this.managerPassword = null;
        }
        if (this.groupMembershipStrategy == null) {
            this.groupMembershipStrategy = new FromGroupSearchLDAPGroupMembershipStrategy(this.groupMembershipFilter);
            this.groupMembershipFilter = null;
        }
        return this;
    }

    public String getServerUrl() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : Util.fixNull((String)this.server).split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(LDAPSecurityRealm.addPrefix(s));
        }
        return buf.toString();
    }

    public IdStrategy getUserIdStrategy() {
        return this.userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.userIdStrategy;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.groupIdStrategy;
    }

    public CacheConfiguration getCache() {
        return this.cache;
    }

    public Integer getCacheSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Integer getCacheTTL() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getTtl());
    }

    @Deprecated
    public String getGroupMembershipFilter() {
        return this.groupMembershipFilter;
    }

    public LDAPGroupMembershipStrategy getGroupMembershipStrategy() {
        return this.groupMembershipStrategy;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public Map<String, String> getExtraEnvVars() {
        return this.extraEnvVars == null || this.extraEnvVars.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.extraEnvVars);
    }

    public EnvironmentProperty[] getEnvironmentProperties() {
        if (this.extraEnvVars == null || this.extraEnvVars.isEmpty()) {
            return new EnvironmentProperty[0];
        }
        EnvironmentProperty[] result = new EnvironmentProperty[this.extraEnvVars.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.extraEnvVars.entrySet()) {
            result[i++] = new EnvironmentProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), ""));
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    static String toProviderUrl(String serverUrl, String rootDN) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0 || (s = LDAPSecurityRealm.getProviderUrl(s, rootDN)) == null) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static String getProviderUrl(String server, String rootDN) {
        if (!(server = LDAPSecurityRealm.addPrefix(server)).endsWith("/")) {
            server = server + '/';
        }
        if (rootDN != null && !(rootDN = rootDN.trim()).isEmpty()) {
            try {
                server = server + new URI(null, null, rootDN, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "Unable to build URL with rootDN: " + server, e);
                return null;
            }
        }
        return server;
    }

    public String getManagerPassword() {
        return Secret.toString((Secret)this.managerPasswordSecret);
    }

    public Secret getManagerPasswordSecret() {
        return this.managerPasswordSecret;
    }

    public String getLDAPURL() {
        return LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), Util.fixNull((String)this.rootDN));
    }

    public String getDisplayNameAttributeName() {
        return StringUtils.defaultString((String)this.displayNameAttributeName, (String)"displayname");
    }

    public String getMailAddressAttributeName() {
        return StringUtils.defaultString((String)this.mailAddressAttributeName, (String)"mail");
    }

    @Nonnull
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Binding binding = new Binding();
        binding.setVariable("instance", (Object)this);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        BeanBuilder builder = new BeanBuilder(jenkins.pluginManager.uberClassLoader);
        String fileName = "LDAPBindSecurityRealm.groovy";
        try {
            File override = new File(jenkins.getRootDir(), fileName);
            builder.parse((InputStream)new AutoCloseInputStream(override.exists() ? new FileInputStream(override) : ((Object)((Object)this)).getClass().getResourceAsStream(fileName)), binding);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Failed to load " + fileName, e);
        }
        WebApplicationContext appContext = builder.createApplicationContext();
        this.ldapTemplate = new LdapTemplate((InitialDirContextFactory)LDAPSecurityRealm.findBean(InitialDirContextFactory.class, (ApplicationContext)appContext));
        if (this.groupMembershipStrategy != null) {
            this.groupMembershipStrategy.setAuthoritiesPopulator((LdapAuthoritiesPopulator)LDAPSecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext));
        }
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new LDAPAuthenticationManager((AuthenticationManager)LDAPSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext)), (UserDetailsService)new LDAPUserDetailsService(appContext, this.groupMembershipStrategy));
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return this.updateUserDetails((UserDetails)this.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(username), (Object)password)).getPrincipal());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.updateUserDetails(this.getSecurityComponents().userDetails.loadUserByUsername(LDAPSecurityRealm.fixUsername(username)));
    }

    public Authentication updateUserDetails(Authentication authentication) {
        this.updateUserDetails((UserDetails)authentication.getPrincipal());
        return authentication;
    }

    public UserDetails updateUserDetails(UserDetails userDetails) {
        if (userDetails instanceof LdapUserDetails) {
            this.updateUserDetails((LdapUserDetails)userDetails);
        }
        return userDetails;
    }

    public LdapUserDetails updateUserDetails(LdapUserDetails d) {
        Attribute attribute;
        User u = User.get((String)LDAPSecurityRealm.fixUsername(d.getUsername()));
        try {
            String displayName;
            attribute = d.getAttributes().get(this.getDisplayNameAttributeName());
            String string = displayName = attribute == null ? null : (String)attribute.get();
            if (StringUtils.isNotBlank((String)displayName) && u.getId().equals(u.getFullName()) && !u.getFullName().equals(displayName)) {
                u.setFullName(displayName);
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.FINEST, "Could not retrieve display name attribute", e);
        }
        if (!this.disableMailAddressResolver) {
            try {
                Mailer.UserProperty existing;
                String mailAddress;
                attribute = d.getAttributes().get(this.getMailAddressAttributeName());
                String string = mailAddress = attribute == null ? null : (String)attribute.get();
                if (StringUtils.isNotBlank((String)mailAddress) && ((existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)) == null || !existing.hasExplicitlyConfiguredAddress())) {
                    u.addProperty((UserProperty)new Mailer.UserProperty(mailAddress));
                }
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINEST, "Could not retrieve email address attribute", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        Set groups;
        Set cachedGroups;
        groupname = LDAPSecurityRealm.fixGroupname(groupname);
        if (this.cache != null) {
            CacheEntry<Set<String>> cached;
            LDAPSecurityRealm lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                cached = this.groupDetailsCache != null ? this.groupDetailsCache.get(groupname) : null;
            }
            cachedGroups = cached != null && cached.isValid() ? cached.getValue() : null;
        } else {
            cachedGroups = null;
        }
        String searchBase = this.groupSearchBase != null ? this.groupSearchBase : "";
        String searchFilter = this.groupSearchFilter != null ? this.groupSearchFilter : GROUP_SEARCH;
        Set set = groups = cachedGroups != null ? cachedGroups : this.ldapTemplate.searchForSingleAttributeValues(searchBase, searchFilter, (Object[])new String[]{groupname}, "cn");
        if (this.cache != null && cachedGroups == null && !groups.isEmpty()) {
            LDAPSecurityRealm lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                if (this.groupDetailsCache == null) {
                    this.groupDetailsCache = new CacheMap<String, Set<String>>(this.cache.getSize());
                }
                this.groupDetailsCache.put(groupname, new CacheEntry<Set>(this.cache.getTtl(), groups));
            }
        }
        if (groups.isEmpty()) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetailsImpl(LDAPSecurityRealm.fixGroupname((String)groups.iterator().next()));
    }

    private static String fixGroupname(String groupname) {
        return FORCE_GROUPNAME_LOWERCASE ? groupname.toLowerCase() : groupname;
    }

    private static String fixUsername(String username) {
        return FORCE_USERNAME_LOWERCASE ? username.toLowerCase() : username;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    public static class EnvironmentProperty
    extends AbstractDescribableImpl<EnvironmentProperty>
    implements Serializable {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> toMap(List<EnvironmentProperty> properties) {
            if (properties != null) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (EnvironmentProperty property : properties) {
                    result.put(property.getName(), property.getValue());
                }
                return result;
            }
            return null;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentProperty> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, CacheEntry<V>> {
        private final int cacheSize;

        public CacheMap(int cacheSize) {
            super(cacheSize + 1);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> eldest) {
            return this.size() > this.cacheSize || eldest.getValue() == null || !eldest.getValue().isValid();
        }
    }

    private static class CacheEntry<T> {
        private final long expires;
        private final T value;

        public CacheEntry(int ttlSeconds, T value) {
            this.expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttlSeconds);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isValid() {
            return System.currentTimeMillis() < this.expires;
        }
    }

    public static class CacheConfiguration
    extends AbstractDescribableImpl<CacheConfiguration> {
        private final int size;
        private final int ttl;

        @DataBoundConstructor
        public CacheConfiguration(int size, int ttl) {
            this.size = Math.max(10, Math.min(size, 1000));
            this.ttl = Math.max(30, Math.min(ttl, 3600));
        }

        public int getSize() {
            return this.size;
        }

        public int getTtl() {
            return this.ttl;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CacheConfiguration> {
            public String getDisplayName() {
                return "";
            }

            public ListBoxModel doFillSizeItems() {
                ListBoxModel m = new ListBoxModel();
                m.add("10");
                m.add("20");
                m.add("50");
                m.add("100");
                m.add("200");
                m.add("500");
                m.add("1000");
                return m;
            }

            public ListBoxModel doFillTtlItems() {
                ListBoxModel m = new ListBoxModel();
                for (int ttl : new int[]{30, 60, 120, 300, 600, 900, 1800, 3600}) {
                    m.add(Util.getTimeSpanString((long)((long)ttl * 1000L)), Integer.toString(ttl));
                }
                return m;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public static final String DEFAULT_DISPLAYNAME_ATTRIBUTE_NAME = "displayname";
        public static final String DEFAULT_MAILADDRESS_ATTRIBUTE_NAME = "mail";
        public static final String DEFAULT_USER_SEARCH = "uid={0}";

        public String getDisplayName() {
            return Messages.LDAPSecurityRealm_DisplayName();
        }

        public IdStrategy getDefaultIdStrategy() {
            return IdStrategy.CASE_INSENSITIVE;
        }

        @RequirePOST
        public FormValidation doValidate(StaplerRequest req) throws Exception {
            if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            JSONObject json = JSONObject.fromObject((Object)IOUtils.toString((InputStream)req.getInputStream()));
            String user = json.getString("testUser");
            String password = json.getString("testPassword");
            JSONObject realmCfg = json.getJSONObject("useSecurity").getJSONObject("realm");
            LDAPSecurityRealm realm = (LDAPSecurityRealm)((Object)req.bindJSON(LDAPSecurityRealm.class, realmCfg));
            return this.validate(realm, user, password);
        }

        private void rsp(StringBuilder response, String kind, String testId, String message, Object ... extras) {
            response.append("<div class='").append(kind).append("' data-test='");
            response.append(Util.escape((String)testId));
            response.append("'>");
            response.append(message);
            boolean needBr = true;
            for (Object extra : extras) {
                if (extra instanceof String) {
                    if (needBr) {
                        response.append("<br/>");
                    }
                    response.append(extra);
                    needBr = true;
                    continue;
                }
                if (!(extra instanceof Collection)) continue;
                response.append("<ul>");
                for (String item : (Collection)extra) {
                    response.append("<li>");
                    response.append(item);
                    response.append("</li>");
                }
                response.append("</ul>");
                needBr = false;
            }
            response.append("</div>");
        }

        private void ok(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "validation-ok", testId, message, extras);
        }

        private void warning(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "warning", testId, message, extras);
        }

        private void error(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "error", testId, message, extras);
        }

        public FormValidation validate(LDAPSecurityRealm realm, String user, String password) {
            FormValidation connnectionCheck = this.doCheckServer(realm.getServerUrl(), realm.managerDN, realm.managerPasswordSecret);
            if (connnectionCheck.kind != FormValidation.Kind.OK) {
                return connnectionCheck;
            }
            StringBuilder response = new StringBuilder(1024);
            response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LoginHeader()).append("</div>");
            boolean potentialLockout = false;
            LdapUserDetails loginDetails = null;
            try {
                loginDetails = (LdapUserDetails)realm.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(user), (Object)password)).getPrincipal();
                this.ok(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationSuccessful(), new Object[0]);
            }
            catch (AuthenticationException e) {
                if (StringUtils.isBlank((String)password)) {
                    this.warning(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationFailedEmptyPass(user), new Object[0]);
                }
                this.error(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationFailed(user), new Object[0]);
                potentialLockout = true;
            }
            HashSet<String> loginAuthorities = new HashSet<String>();
            if (loginDetails != null) {
                this.ok(response, "authentication-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserId(Util.escape((String)loginDetails.getUsername())), new Object[0]);
                this.ok(response, "authentication-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDn(Util.escape((String)loginDetails.getDn())), new Object[0]);
                this.validateDisplayName(realm, response, loginDetails, "authentication-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(realm, response, loginDetails, "authentication-email");
                }
                for (GrantedAuthority a : loginDetails.getAuthorities()) {
                    loginAuthorities.add(a.getAuthority());
                }
                if (loginDetails.getAuthorities().length < 1) {
                    this.error(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                } else if (loginDetails.getAuthorities().length == 1) {
                    this.warning(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembership(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                } else {
                    ArrayList<String> authorities = new ArrayList<String>();
                    for (GrantedAuthority a : loginDetails.getAuthorities()) {
                        if (SecurityRealm.AUTHENTICATED_AUTHORITY.equals(a)) continue;
                        authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                    }
                    this.ok(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                }
            }
            response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LookupHeader()).append("</div>");
            LdapUserDetails lookUpDetails = null;
            try {
                lookUpDetails = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(LDAPSecurityRealm.fixUsername(user));
                this.ok(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupSuccessful(), new Object[0]);
            }
            catch (UserMayOrMayNotExistException e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupInconclusive(user), StringUtils.isBlank((String)realm.managerDN) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
            }
            catch (UsernameNotFoundException e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupDoesNotExist(user), StringUtils.isBlank((String)realm.managerDN) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupSettingsCorrect());
            }
            catch (LdapDataAccessException e) {
                Throwable cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof BadCredentialsException); cause = cause.getCause()) {
                }
                if (cause != null) {
                    this.error(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupBadCredentials(), StringUtils.isBlank((String)realm.managerDN) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnCorrect() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
                    potentialLockout = true;
                }
                this.error(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupFailed(user), Util.escape((String)e.getLocalizedMessage()));
                potentialLockout = true;
            }
            if (loginDetails == null && lookUpDetails != null) {
                this.ok(response, "lookup-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserId(Util.escape((String)lookUpDetails.getUsername())), new Object[0]);
                this.ok(response, "lookup-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDn(Util.escape((String)lookUpDetails.getDn())), new Object[0]);
                this.validateDisplayName(realm, response, lookUpDetails, "lookup-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(realm, response, lookUpDetails, "lookup-email");
                }
            }
            HashSet<String> lookupAuthorities = new HashSet<String>();
            if (lookUpDetails != null) {
                for (GrantedAuthority a : lookUpDetails.getAuthorities()) {
                    lookupAuthorities.add(a.getAuthority());
                }
                if (loginDetails == null || !loginAuthorities.equals(lookupAuthorities)) {
                    if (lookUpDetails.getAuthorities().length < 1) {
                        this.error(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                    } else if (lookUpDetails.getAuthorities().length == 1) {
                        this.warning(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembership(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                    } else {
                        ArrayList<String> authorities = new ArrayList<String>();
                        for (GrantedAuthority a : lookUpDetails.getAuthorities()) {
                            if (SecurityRealm.AUTHENTICATED_AUTHORITY.equals(a)) continue;
                            authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                        }
                        this.ok(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                    }
                }
            }
            if (loginDetails != null && lookUpDetails != null) {
                if (!StringUtils.equals((String)loginDetails.getUsername(), (String)lookUpDetails.getUsername())) {
                    this.error(response, "consistency-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UsernameMismatch(loginDetails.getUsername(), lookUpDetails.getUsername()), new Object[0]);
                    potentialLockout = true;
                }
                if (!StringUtils.equals((String)loginDetails.getDn(), (String)lookUpDetails.getDn())) {
                    this.error(response, "consistency-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_DnMismatch(loginDetails.getDn(), lookUpDetails.getDn()), new Object[0]);
                    potentialLockout = true;
                }
                if (StringUtils.isNotBlank((String)realm.getDisplayNameAttributeName())) {
                    Class<?> lookUpValue;
                    Class<?> loginValue;
                    Attribute loginAttr = loginDetails.getAttributes().get(realm.getDisplayNameAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    Attribute lookUpAttr = lookUpDetails.getAttributes().get(realm.getDisplayNameAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-displayname", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_DisplayNameMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (!realm.disableMailAddressResolver && StringUtils.isNotBlank((String)realm.getMailAddressAttributeName())) {
                    Class<?> lookUpValue;
                    Class<?> loginValue;
                    Attribute loginAttr = loginDetails.getAttributes().get(realm.getMailAddressAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    Attribute lookUpAttr = lookUpDetails.getAttributes().get(realm.getMailAddressAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-email", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmailAddressMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (loginAuthorities.equals(lookupAuthorities)) {
                    this.ok(response, "consistency", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembershipMatch(), new Object[0]);
                } else {
                    this.error(response, "consistency", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembershipMismatch(), new Object[0]);
                    potentialLockout = true;
                }
            }
            HashSet<String> groups = new HashSet<String>(loginAuthorities);
            TreeSet<String> badGroups = new TreeSet<String>();
            groups.addAll(lookupAuthorities);
            groups.remove(SecurityRealm.AUTHENTICATED_AUTHORITY.getAuthority());
            for (String group : groups) {
                try {
                    realm.loadGroupByGroupname(group);
                }
                catch (UsernameNotFoundException e) {
                    badGroups.add(group);
                }
            }
            if (groups.isEmpty()) {
                this.warning(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupNotPossible(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupNotPossibleDetail());
            } else if (badGroups.isEmpty()) {
                this.ok(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupSuccessful(groups.size()), new Object[0]);
            } else {
                ArrayList<String> escaped = new ArrayList<String>(badGroups.size());
                for (String group : badGroups) {
                    escaped.add("<code>" + Util.escape((String)group) + "</code>");
                }
                this.warning(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupFailed(badGroups.size()), escaped, StringUtils.isBlank((String)realm.managerDN) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupManagerDnPermissions(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupSettingsCorrect());
            }
            if (potentialLockout) {
                response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LockoutHeader()).append("</div>");
                this.error(response, "lockout", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_PotentialLockout(user), new Object[0]);
            }
            return FormValidation.okWithMarkup((String)response.toString());
        }

        private void validateEmailAddress(LDAPSecurityRealm realm, StringBuilder response, LdapUserDetails details, String testId) {
            Attribute attribute = details.getAttributes().get(realm.getMailAddressAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(details.getAttributes().getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String mailAddress = (String)attribute.get();
                    if (StringUtils.isNotBlank((String)mailAddress)) {
                        this.ok(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserEmail(Util.escape((String)mailAddress)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(details.getAttributes().getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmptyEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(details.getAttributes().getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_CouldNotRetrieveEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }

        private void validateDisplayName(LDAPSecurityRealm realm, StringBuilder response, LdapUserDetails details, String testId) {
            Attribute attribute = details.getAttributes().get(realm.getDisplayNameAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(details.getAttributes().getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String displayName = (String)attribute.get();
                    if (displayName != null) {
                        this.ok(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDisplayName(Util.escape((String)displayName)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(details.getAttributes().getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmptyDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(details.getAttributes().getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_CouldNotRetrieveDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)realm.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }

        public FormValidation doCheckServer(@QueryParameter String value, @QueryParameter String managerDN, @QueryParameter Secret managerPasswordSecret) {
            String server = value;
            String managerPassword = Secret.toString((Secret)managerPasswordSecret);
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)"Jenkins is not ready. Cannot validate the field");
            }
            if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(server, ""));
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps?://)?([^:]+)(?:\\:(\\d+))?(\\s+(ldaps?://)?([^:]+)(?:\\:(\\d+))?)*").matcher(server.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress adrs = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(adrs, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_UnknownHost((Object)x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)Messages.LDAPSecurityRealm_InvalidPortNumber());
            }
        }

        public DescriptorExtensionList<LDAPGroupMembershipStrategy, Descriptor<LDAPGroupMembershipStrategy>> getGroupMembershipStrategies() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                return jenkins.getDescriptorList(LDAPGroupMembershipStrategy.class);
            }
            return DescriptorExtensionList.createDescriptorList((Jenkins)null, LDAPGroupMembershipStrategy.class);
        }
    }

    public static final class AuthoritiesPopulatorImpl
    extends DefaultLdapAuthoritiesPopulator {
        String rolePrefix = "ROLE_";
        boolean convertToUpperCase = true;
        private GrantedAuthority defaultRole = null;

        public AuthoritiesPopulatorImpl(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
            super(initialDirContextFactory, Util.fixNull((String)groupSearchBase));
            super.setRolePrefix("");
            super.setConvertToUpperCase(false);
        }

        public Set getAdditionalRoles(LdapUserDetails ldapUser) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
        }

        public void setRolePrefix(String rolePrefix) {
            this.rolePrefix = rolePrefix;
        }

        public void setConvertToUpperCase(boolean convertToUpperCase) {
            this.convertToUpperCase = convertToUpperCase;
        }

        public Set getGroupMembershipRoles(String userDn, String username) {
            Set names = super.getGroupMembershipRoles(userDn, username);
            HashSet<GrantedAuthorityImpl> r = new HashSet<GrantedAuthorityImpl>(names.size() * 2);
            r.addAll(names);
            if (this.isGeneratingPrefixRoles()) {
                for (GrantedAuthority ga : names) {
                    String role = ga.getAuthority();
                    if (this.convertToUpperCase) {
                        role = role.toUpperCase();
                    }
                    r.add(new GrantedAuthorityImpl(this.rolePrefix + role));
                }
            }
            return r;
        }

        public boolean isGeneratingPrefixRoles() {
            return StringUtils.isNotBlank((String)this.rolePrefix) || this.convertToUpperCase;
        }

        public boolean isConvertToUpperCase() {
            return this.convertToUpperCase;
        }

        public String getRolePrefix() {
            return this.rolePrefix;
        }

        public GrantedAuthority getDefaultRole() {
            return this.defaultRole;
        }

        public void setDefaultRole(String defaultRole) {
            super.setDefaultRole(defaultRole);
            this.defaultRole = new GrantedAuthorityImpl(defaultRole);
        }
    }

    private static final class WrappedAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        private final LDAPGroupMembershipStrategy strategy;
        private final LdapAuthoritiesPopulator populator;

        private WrappedAuthoritiesPopulator(LDAPGroupMembershipStrategy strategy, LdapAuthoritiesPopulator populator) {
            this.strategy = strategy;
            this.populator = populator;
            strategy.setAuthoritiesPopulator(populator);
        }

        public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails userDetails) throws LdapDataAccessException {
            if (this.strategy.getAuthoritiesPopulator() != this.populator) {
                this.strategy.setAuthoritiesPopulator(this.populator);
            }
            return this.strategy.getGrantedAuthorities(userDetails);
        }
    }

    public static final class LdapAuthenticationProviderImpl
    extends LdapAuthenticationProvider {
        public LdapAuthenticationProviderImpl(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            super(authenticator, (LdapAuthoritiesPopulator)(groupMembershipStrategy != null ? new WrappedAuthoritiesPopulator(groupMembershipStrategy, authoritiesPopulator) : authoritiesPopulator));
        }
    }

    @Extension
    public static final class MailAdressResolverImpl
    extends MailAddressResolver {
        public String findMailAddressFor(User u) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return null;
            }
            SecurityRealm realm = jenkins.getSecurityRealm();
            if (!(realm instanceof LDAPSecurityRealm)) {
                return null;
            }
            if (((LDAPSecurityRealm)realm).disableMailAddressResolver) {
                LOGGER.info("LDAPSecurityRealm MailAddressResolver is disabled");
                return null;
            }
            try {
                LdapUserDetails details = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
                Attribute mail = details.getAttributes().get(((LDAPSecurityRealm)realm).getMailAddressAttributeName());
                if (mail == null) {
                    return null;
                }
                return (String)mail.get();
            }
            catch (UsernameNotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (AcegiSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
        }
    }

    public static class LDAPUserDetailsService
    implements UserDetailsService {
        public final LdapUserSearch ldapSearch;
        public final LdapAuthoritiesPopulator authoritiesPopulator;
        public final LDAPGroupMembershipStrategy groupMembershipStrategy;
        private final LRUMap attributesCache = new LRUMap(32);

        LDAPUserDetailsService(WebApplicationContext appContext) {
            this(appContext, null);
        }

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
            this(ldapSearch, authoritiesPopulator, null);
        }

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            this.ldapSearch = ldapSearch;
            this.authoritiesPopulator = authoritiesPopulator;
            this.groupMembershipStrategy = groupMembershipStrategy;
        }

        public LDAPUserDetailsService(WebApplicationContext appContext, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            this((LdapUserSearch)SecurityRealm.findBean(LdapUserSearch.class, (ApplicationContext)appContext), (LdapAuthoritiesPopulator)SecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext), groupMembershipStrategy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            username = LDAPSecurityRealm.fixUsername(username);
            try {
                LDAPSecurityRealm ldapSecurityRealm;
                LdapUserDetails ldapUser;
                LDAPSecurityRealm lDAPSecurityRealm;
                LDAPSecurityRealm ldapSecurityRealm2;
                SecurityRealm securityRealm;
                Jenkins jenkins = Jenkins.getInstance();
                SecurityRealm securityRealm2 = securityRealm = jenkins == null ? null : jenkins.getSecurityRealm();
                if (securityRealm instanceof LDAPSecurityRealm && securityRealm.getSecurityComponents().userDetails == this && (ldapSecurityRealm2 = (LDAPSecurityRealm)securityRealm).cache != null) {
                    CacheEntry cached;
                    lDAPSecurityRealm = ldapSecurityRealm2;
                    synchronized (lDAPSecurityRealm) {
                        cached = ldapSecurityRealm2.userDetailsCache != null ? (CacheEntry)ldapSecurityRealm2.userDetailsCache.get(username) : null;
                    }
                    if (cached != null && cached.isValid()) {
                        return (LdapUserDetails)cached.getValue();
                    }
                }
                if ((ldapUser = this.ldapSearch.searchForUser(username)) != null) {
                    GrantedAuthority[] extraAuthorities;
                    LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                    Attributes v = ldapUser.getAttributes();
                    if (v instanceof BasicAttributes) {
                        LRUMap lRUMap = this.attributesCache;
                        synchronized (lRUMap) {
                            Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                            if (vv == null) {
                                vv = v;
                                this.attributesCache.put((Object)v, (Object)vv);
                            }
                            user.setAttributes(vv);
                        }
                    }
                    for (GrantedAuthority extraAuthority : extraAuthorities = this.groupMembershipStrategy == null ? this.authoritiesPopulator.getGrantedAuthorities(ldapUser) : this.groupMembershipStrategy.getGrantedAuthorities(ldapUser)) {
                        if (FORCE_GROUPNAME_LOWERCASE) {
                            user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl(extraAuthority.getAuthority().toLowerCase()));
                            continue;
                        }
                        user.addAuthority(extraAuthority);
                    }
                    ldapUser = user.createUserDetails();
                }
                if (securityRealm instanceof LDAPSecurityRealm && securityRealm.getSecurityComponents().userDetails == this && (ldapSecurityRealm = (LDAPSecurityRealm)securityRealm).cache != null) {
                    lDAPSecurityRealm = ldapSecurityRealm;
                    synchronized (lDAPSecurityRealm) {
                        if (ldapSecurityRealm.userDetailsCache == null) {
                            ldapSecurityRealm.userDetailsCache = new CacheMap(ldapSecurityRealm.cache.getSize());
                        }
                        ldapSecurityRealm.userDetailsCache.put(username, new CacheEntry<LdapUserDetails>(ldapSecurityRealm.cache.getTtl(), ldapSecurityRealm.updateUserDetails(ldapUser)));
                    }
                }
                return ldapUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
            catch (UsernameNotFoundException x) {
                throw x;
            }
            catch (DataAccessException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new LdapDataAccessException("Failed to search LDAP for " + username + ": " + x, (Throwable)x);
            }
        }
    }

    private class LDAPAuthenticationManager
    implements AuthenticationManager {
        private final AuthenticationManager delegate;

        private LDAPAuthenticationManager(AuthenticationManager delegate) {
            this.delegate = delegate;
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return LDAPSecurityRealm.this.updateUserDetails(this.delegate.authenticate(authentication));
        }
    }

    private static class GroupDetailsImpl
    extends GroupDetails {
        private String name;

        public GroupDetailsImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

