/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.util;

import com.klocwork.kwjenkinsplugin.definitions.KlocworkIssue;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkSeverities;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkStatuses;
import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KlocworkXMLReportHandler
extends DefaultHandler {
    private int totalIssueCount = 0;
    private ArrayList<KlocworkIssue> issuesList = new ArrayList();
    private Stack<String> elementStack = new Stack();
    private StringBuilder element = new StringBuilder();
    private KlocworkIssue issue;
    private boolean enableHTMLReport;
    private final KlocworkSeverities enabledSeverites;
    private final KlocworkStatuses enabledStatuses;

    public KlocworkXMLReportHandler(boolean enableHTMLReport, KlocworkSeverities enabledSeverites, KlocworkStatuses enabledStatuses) {
        this.enableHTMLReport = enableHTMLReport;
        this.enabledSeverites = enabledSeverites;
        this.enabledStatuses = enabledStatuses;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(qName);
        if (qName.equalsIgnoreCase("problem")) {
            this.issue = new KlocworkIssue();
        }
        this.element.delete(0, this.element.length());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName.toLowerCase()) {
            case "problemid": {
                this.issue.setId(this.element.toString());
                break;
            }
            case "code": {
                this.issue.setCode(this.element.toString());
                break;
            }
            case "file": {
                this.issue.setFile(this.element.toString());
                break;
            }
            case "line": {
                this.issue.setLine(this.element.toString());
                break;
            }
            case "message": {
                this.issue.setMessage(this.element.toString());
                break;
            }
            case "severity": {
                this.issue.setSeverity(this.element.toString());
                break;
            }
            case "severitylevel": {
                this.issue.setSeverityCode(this.element.toString());
                break;
            }
            case "citingstatus": {
                this.issue.setStatus(this.element.toString());
                break;
            }
            case "problem": {
                if ((this.enabledSeverites.getEnabled().get("fiveToTen").booleanValue() && 10 - Integer.parseInt(this.issue.getSeverityCode()) < 6 || this.enabledSeverites.getEnabled().get(this.getSeverity_en(Integer.parseInt(this.issue.getSeverityCode()))).booleanValue()) && this.enabledStatuses.getEnabled().get(this.issue.getStatus().toLowerCase()).booleanValue()) {
                    ++this.totalIssueCount;
                    if (this.enableHTMLReport) {
                        this.issuesList.add(this.issue);
                    }
                }
                this.issue = null;
                break;
            }
        }
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (!text.trim().isEmpty()) {
            this.element.append(text);
        }
    }

    private String getSeverity_en(int severityLevel) {
        String severity_en = "";
        switch (severityLevel) {
            case 1: {
                severity_en = "critical";
                break;
            }
            case 2: {
                severity_en = "error";
                break;
            }
            case 3: {
                severity_en = "warning";
                break;
            }
            case 4: {
                severity_en = "review";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                severity_en = "fiveToTen";
            }
        }
        return severity_en;
    }

    private String currentElement() {
        return this.elementStack.peek();
    }

    private String currentElementParent() {
        if (this.elementStack.size() < 2) {
            return null;
        }
        return (String)this.elementStack.get(this.elementStack.size() - 2);
    }

    public int getTotalIssueCount() {
        return this.totalIssueCount;
    }

    public ArrayList<KlocworkIssue> getIssuesList() {
        return this.issuesList;
    }
}

