/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.util;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.config.KlocworkCiConfig;
import com.klocwork.kwjenkinsplugin.services.KlocworkApiConnection;
import com.klocwork.kwjenkinsplugin.util.KlocworkLtokenFetcher;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;

public class KlocworkUtil {
    public static void validateServerConfigs(EnvVars envVars) throws AbortException {
        KlocworkUtil.validateServerURL(envVars);
        KlocworkUtil.validateServerProject(envVars);
    }

    public static void validateServerURL(EnvVars envVars) throws AbortException {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_URL)))) {
            throw new AbortException("Klocwork Server not specified. Klocwork servers are configured on the Jenkins global configuration page and referenced under Build Environment settings on the Job configuration page.");
        }
    }

    private static void validateServerProject(EnvVars envVars) throws AbortException {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT)))) {
            throw new AbortException("Klocwork Server Project not specified. Server projects are provided under Build Environment settings on the Job configuration page.");
        }
    }

    public static String[] getLtokenValues(EnvVars envVars, Launcher launcher) throws AbortException {
        try {
            Object[] ltokenLine = (String[])launcher.getChannel().call((Callable)new KlocworkLtokenFetcher((String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL), (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LTOKEN)));
            if (ltokenLine.length < 4) {
                throw new IOException("Error: ltoken string returned is too short: \"" + Arrays.toString(ltokenLine) + "\"");
            }
            if (StringUtils.isEmpty((CharSequence)ltokenLine[2])) {
                throw new IOException("Error: ltoken invalid. Reason: user is empty\"" + Arrays.toString(ltokenLine) + "\"");
            }
            if (StringUtils.isEmpty((CharSequence)ltokenLine[3])) {
                throw new IOException("Error: ltoken invalid. Reason: ltoken is empty\"" + Arrays.toString(ltokenLine) + "\"");
            }
            return ltokenLine;
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
    }

    public static String getKlocworkProjectUrl(EnvVars envVars) throws AbortException {
        try {
            URL url = new URL(KlocworkUtil.getNormalizedKlocworkUrl(envVars) + (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT));
            return url.toString();
        }
        catch (MalformedURLException ex) {
            throw new AbortException(ex.getMessage());
        }
    }

    public static String getNormalizedKlocworkUrl(EnvVars envVars) {
        String urlStr = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL);
        return urlStr.endsWith("/") ? urlStr : urlStr + "/";
    }

    public static String getIssueListUrl(String url, String project) {
        return String.format("%sreview/insight-review.html#issuelist_goto:project=%s", url, project);
    }

    public static String getBuildIssueListUrl(String url, String project, String buildName) throws UnsupportedEncodingException {
        return String.format("%s,searchquery=%s", KlocworkUtil.getIssueListUrl(url, project), URLEncoder.encode(String.format("build:%s", buildName), "UTF-8"));
    }

    public static String getBuildSpecPath(String buildSpec, FilePath workspace) throws AbortException {
        return new FilePath(workspace, KlocworkUtil.getDefaultBuildSpec(buildSpec)).getRemote();
    }

    public static String getDefaultBuildSpec(String buildSpec) {
        return StringUtils.isEmpty((CharSequence)buildSpec) ? "kwinject.out" : buildSpec;
    }

    public static String getDefaultKwtablesDir(String tablesDir) {
        return StringUtils.isEmpty((CharSequence)tablesDir) ? "kwtables" : tablesDir;
    }

    public static String getDefaultReportFileName(String reportFile) {
        return StringUtils.isEmpty((CharSequence)reportFile) ? "kwciagent_report.xml" : reportFile;
    }

    public static String getJsonReportFileName() {
        return "kwciagent_report.json";
    }

    public static String getDefaultBuildName(String buildName, EnvVars envVars) {
        if (StringUtils.isEmpty((CharSequence)buildName)) {
            return (String)envVars.get((Object)"BUILD_TAG");
        }
        return envVars.expand(buildName);
    }

    public static int executeCommand(Launcher launcher, TaskListener listener, FilePath buildDir, EnvVars envVars, ArgumentListBuilder cmds) throws AbortException {
        return KlocworkUtil.executeCommand(launcher, listener, buildDir, envVars, cmds, false);
    }

    public static int executeCommand(Launcher launcher, TaskListener listener, FilePath buildDir, EnvVars envVars, ArgumentListBuilder cmds, boolean ignoreReturnCode) throws AbortException {
        if (launcher.isUnix()) {
            cmds = new ArgumentListBuilder(new String[]{"/bin/sh", "-c", cmds.toString()});
        } else {
            cmds.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            cmds = new ArgumentListBuilder(new String[]{"cmd.exe", "/C", cmds.toString()});
        }
        try {
            int returnCode = launcher.launch().stdout(listener).stderr((OutputStream)listener.getLogger()).pwd(buildDir).envs((Map)envVars).cmds(cmds).join();
            listener.getLogger().println("Return code: " + returnCode);
            if (!ignoreReturnCode && returnCode != 0) {
                throw new AbortException("Non-zero Return Code. Aborting.");
            }
            return returnCode;
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
    }

    public static Map<StreamReferences, ByteArrayOutputStream> executeCommandParseOutput(Launcher launcher, FilePath buildDir, EnvVars envVars, ArgumentListBuilder cmds) throws AbortException {
        if (launcher.isUnix()) {
            cmds = new ArgumentListBuilder(new String[]{"/bin/sh", "-c", cmds.toString()});
        } else {
            cmds.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            cmds = new ArgumentListBuilder(new String[]{"cmd.exe", "/C", cmds.toString()});
        }
        try {
            HashMap<StreamReferences, ByteArrayOutputStream> outputStreams = new HashMap<StreamReferences, ByteArrayOutputStream>();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStreams.put(StreamReferences.OUT_STREAM, outputStream);
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            outputStreams.put(StreamReferences.ERR_STREAM, errorStream);
            launcher.launch().stdout((OutputStream)outputStream).stderr((OutputStream)errorStream).pwd(buildDir).envs((Map)envVars).cmds(cmds).join();
            return outputStreams;
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int generateKwListOutput(FilePath xmlReport, ByteArrayOutputStream outputStream, TaskListener listener, String ciTool, Launcher launcher) {
        int returnCode = 0;
        if (ciTool.equalsIgnoreCase(KlocworkCiConfig.getCiTool())) {
            try {
                if (launcher.isUnix()) {
                    outputStream.writeTo(xmlReport.write());
                } else {
                    xmlReport.write().write(outputStream.toString().replaceFirst("MS932", "UTF-8").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException | InterruptedException e) {
                returnCode = 1;
                listener.getLogger().println(e.getMessage());
            }
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                BufferedReader bufferedReader = null;
                bufferedReader = launcher.isUnix() ? new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(inputStream));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    if (line.trim().startsWith("<problemID>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<file>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<method>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<code>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<message>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<citingStatus>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<severity>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<severitylevel>")) {
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (!line.trim().startsWith("</problem>")) continue;
                    listener.getLogger().println();
                }
            }
            catch (IOException e) {
                returnCode = 1;
                listener.getLogger().println(e.getMessage());
            }
            finally {
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception ex) {
                    returnCode = 1;
                }
            }
        } else {
            InputStream inputStream = null;
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(xmlReport.write(), StandardCharsets.UTF_8));
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
                bufferedWriter.newLine();
                bufferedWriter.write("<errorList>");
                bufferedWriter.newLine();
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                BufferedReader bufferedReader = null;
                bufferedReader = launcher.isUnix() ? new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(inputStream));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    if (line.trim().startsWith("<problem>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        continue;
                    }
                    if (line.trim().startsWith("<problemID>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<file>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<method>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<code>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<message>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<citingStatus>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<severity>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (line.trim().startsWith("<severitylevel>")) {
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        matcher = Pattern.compile("<.+>(.+)<.+>").matcher(line);
                        if (!matcher.find()) continue;
                        listener.getLogger().print(matcher.group(1) + "\t");
                        continue;
                    }
                    if (!line.trim().startsWith("</problem>")) continue;
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                    listener.getLogger().println();
                }
                bufferedWriter.write("</errorList>");
                bufferedWriter.newLine();
            }
            catch (IOException | InterruptedException e) {
                returnCode = 1;
                listener.getLogger().println(e.getMessage());
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception ex) {
                    returnCode = 1;
                }
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (Exception ex) {
                    returnCode = 1;
                }
            }
        }
        return returnCode;
    }

    public static String createKlocworkAPIRequestOld(String action, String query, EnvVars envVars) throws AbortException {
        String request = "action=" + action + "&project=" + (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT);
        if (!StringUtils.isEmpty((CharSequence)query)) {
            try {
                request = request + "&query=";
                String queryEncoded = KlocworkUtil.getQueryDefaultGroupingOff(query);
                queryEncoded = queryEncoded + query;
                queryEncoded = URLEncoder.encode(queryEncoded, "UTF-8");
                request = request + queryEncoded;
            }
            catch (UnsupportedEncodingException ex) {
                throw new AbortException(ex.getMessage());
            }
        }
        return request;
    }

    public static String createKlocworkAPIRequest(String action, HashMap<String, String> args) throws AbortException {
        String request = "&action=" + action;
        if (!args.isEmpty()) {
            try {
                for (String key : args.keySet()) {
                    if (action.equals("search") && key.equals("query")) {
                        request = request + "&" + key + "=" + URLEncoder.encode(KlocworkUtil.getQueryDefaultGroupingOff(args.get(key)) + args.get(key), "UTF-8");
                        continue;
                    }
                    request = request + "&" + key + "=" + URLEncoder.encode(args.get(key), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new AbortException(ex.getMessage());
            }
        }
        return request;
    }

    public static JSONArray getJSONResponse(String request, EnvVars envVars, Launcher launcher) throws AbortException {
        JSONArray response;
        try {
            String[] ltokenLine = KlocworkUtil.getLtokenValues(envVars, launcher);
            KlocworkApiConnection kwService = new KlocworkApiConnection((String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL), ltokenLine[2], ltokenLine[3]);
            response = kwService.sendRequest(request);
        }
        catch (IOException ex) {
            throw new AbortException("Error: failed to connect to the Klocwork web API.\nCause: " + ex.getMessage());
        }
        return response;
    }

    private static String getQueryDefaultGroupingOff(String query) {
        if (!query.toLowerCase().contains("grouping:off") && !query.toLowerCase().contains("grouping:on")) {
            return "grouping:off ";
        }
        return "";
    }

    public static ArgumentListBuilder getCreateOrDuplicateCmd(String url, String project, String duplicate, FilePath workspace) {
        ArgumentListBuilder kwadminCmd = new ArgumentListBuilder(new String[]{"kwadmin"});
        kwadminCmd.add(new String[]{"--url", url});
        if (StringUtils.isEmpty((CharSequence)duplicate)) {
            kwadminCmd.add("create-project");
        } else {
            kwadminCmd.add("duplicate-project");
            kwadminCmd.add(duplicate);
        }
        kwadminCmd.add(project);
        return kwadminCmd;
    }

    public static ArgumentListBuilder getProjectListCmd(String url, FilePath workspace) {
        ArgumentListBuilder kwadminCmd = new ArgumentListBuilder(new String[]{"kwadmin"});
        kwadminCmd.add(new String[]{"--url", url});
        kwadminCmd.add("list-projects");
        return kwadminCmd;
    }

    public static boolean projectExists(ByteArrayOutputStream kwadminProjectListOutput, Launcher launcher, String project) throws AbortException {
        ByteArrayInputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = new ByteArrayInputStream(kwadminProjectListOutput.toByteArray());
            bufferedReader = launcher.isUnix() ? new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.trim().equals(project)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception ex) {
                throw new AbortException(ex.getMessage());
            }
        }
        return false;
    }

    public static enum StreamReferences {
        ERR_STREAM,
        OUT_STREAM;

    }
}

