/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;

public class KlocworkLtokenFetcher
extends MasterToSlaveCallable<String[], IOException> {
    private String url;
    private String ltoken;

    public KlocworkLtokenFetcher(String url, String ltoken) {
        this.url = url;
        this.ltoken = ltoken;
    }

    public String[] call() throws IOException {
        URL urlObj = new URL(this.url);
        String host = urlObj.getHost();
        String port = Integer.toString(urlObj.getPort());
        File ltokenFile = null;
        ltokenFile = StringUtils.isEmpty((CharSequence)this.ltoken) ? new File(System.getProperty("user.home") + File.separator + ".klocwork" + File.separator + "ltoken") : new File(this.ltoken);
        if (!ltokenFile.exists()) {
            throw new IOException("Error: could not find Klocwork ltoken at \"" + ltokenFile.getAbsolutePath() + "\"");
        }
        try (Scanner scanner = new Scanner(ltokenFile);){
            while (scanner.hasNextLine()) {
                String[] splitLine = scanner.nextLine().split(";");
                if (!this.isCorrectLtokenLine(splitLine, host, port)) continue;
                String[] stringArray = splitLine;
                return stringArray;
            }
        }
        throw new IOException("Error: could not find a matching ltoken entry in \"" + ltokenFile.getAbsolutePath() + "\" for host \"" + host + " and port \"" + port);
    }

    private boolean isCorrectLtokenLine(String[] splitLine, String host, String port) {
        return splitLine.length == 4 && this.verifyHostAddress(splitLine[0], host) && splitLine[1].equals(port);
    }

    private boolean verifyHostAddress(String hostA, String hostB) {
        try {
            InetAddress addressA = InetAddress.getByName(hostA);
            InetAddress addressB = InetAddress.getByName(hostB);
            return addressA.equals(addressB);
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }
}

