/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkSeverities;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkStatuses;
import com.klocwork.kwjenkinsplugin.dto.KlocworkJsonIssue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.security.MasterToSlaveCallable;

public class KlocworkJsonReportParserIssueList
extends MasterToSlaveCallable<List<KlocworkJsonIssue>, IOException>
implements Serializable {
    private final String workspace;
    private final String jsonReportFile;
    private final KlocworkSeverities enabledSeverities;
    private final KlocworkStatuses enabledStatuses;
    private final String FIVE_TO_TEN_SEVERITY = "fiveToTen";

    public KlocworkJsonReportParserIssueList(String workspace, String jsonReportFile, KlocworkSeverities enabledSeverities, KlocworkStatuses enabledStatuses) {
        this.workspace = workspace;
        this.jsonReportFile = jsonReportFile;
        this.enabledSeverities = enabledSeverities;
        this.enabledStatuses = enabledStatuses;
    }

    public List<KlocworkJsonIssue> call() throws IOException {
        List issues;
        File reportFile = Paths.get(this.jsonReportFile, new String[0]).isAbsolute() ? new File(this.jsonReportFile) : new File(this.workspace, this.jsonReportFile);
        try (FileInputStream jsonInput = new FileInputStream(reportFile);){
            InputStreamReader reader = new InputStreamReader(jsonInput);
            JsonReader jsonReader = new JsonReader((Reader)reader);
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            issues = (List)gson.fromJson(jsonReader, new TypeToken<List<KlocworkJsonIssue>>(){}.getType());
        }
        if (issues == null) {
            return new ArrayList<KlocworkJsonIssue>();
        }
        return issues.stream().filter(issue -> this.enabledStatuses.getEnabled().getOrDefault(issue.getCitingStatus().toLowerCase(), false)).filter(issue -> this.isSeverityInEnabled(Integer.parseInt(issue.getSeverityCode()), issue.getSeverity())).collect(Collectors.toList());
    }

    private boolean isSeverityInEnabled(int severityCode, String severityName) {
        if (this.enabledSeverities.getEnabled().get("fiveToTen").booleanValue() && severityCode >= 5 && severityCode <= 10) {
            return true;
        }
        if (severityName == null) {
            return false;
        }
        return this.enabledSeverities.getEnabled().getOrDefault(severityName.toLowerCase(), false) != false;
    }
}

