/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.services;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class KlocworkApiConnection {
    private URL url;
    private String user;
    private String ltoken;

    public KlocworkApiConnection(String url, String user, String ltoken) throws IOException {
        this.url = new URL(url + "/review/api");
        this.user = user;
        this.ltoken = ltoken;
    }

    private HttpURLConnection createConnection() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpURLConnection httpUrlConnection;
        if (this.url.getProtocol().equals("https")) {
            httpUrlConnection = (HttpsURLConnection)this.url.openConnection();
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(sc.getSocketFactory());
        } else {
            httpUrlConnection = (HttpURLConnection)this.url.openConnection();
        }
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setInstanceFollowRedirects(false);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setUseCaches(false);
        return httpUrlConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray sendRequest(String request) throws IOException {
        JSONArray response = new JSONArray();
        String errorMsg = "";
        request = request + "&user=" + this.user;
        request = request + "&ltoken=" + this.ltoken;
        boolean success = false;
        try {
            HttpURLConnection httpUrlConnection = this.createConnection();
            httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(request.length()));
            try {
                String line;
                DataOutputStream wr = new DataOutputStream(httpUrlConnection.getOutputStream());
                wr.writeBytes(request);
                wr.flush();
                wr.close();
                InputStream inputStream = httpUrlConnection.getErrorStream();
                if (inputStream == null) {
                    success = true;
                    inputStream = httpUrlConnection.getInputStream();
                }
                BufferedReader buf = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream(), "UTF-8"));
                while (null != (line = buf.readLine())) {
                    if (success) {
                        response.add((Object)JSONObject.fromObject((Object)line));
                        continue;
                    }
                    errorMsg = errorMsg + line + "\n";
                }
                buf.close();
                inputStream.close();
            }
            finally {
                if (httpUrlConnection != null) {
                    httpUrlConnection.disconnect();
                }
                httpUrlConnection = null;
            }
        }
        catch (ConnectException | KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IOException("Error: connection to Klocwork Server \"" + this.url.toString() + "\" failed.\nRequest: " + request + "\nCause: " + ex.getMessage(), ex);
        }
        if (!success) {
            throw new IOException("Error: request was not successfully handled by Klocwork server \"" + this.url.toString() + "\".\nRequest: " + request + "\nReturn: " + errorMsg);
        }
        return response;
    }
}

