/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.reporting;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.klocwork.kwjenkinsplugin.config.KlocworkFailureConditionCiConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkFailureConditionConfig;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkSeverities;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkStatuses;
import com.klocwork.kwjenkinsplugin.definitions.Severity;
import com.klocwork.kwjenkinsplugin.definitions.State;
import com.klocwork.kwjenkinsplugin.definitions.Status;
import com.klocwork.kwjenkinsplugin.dto.HtmlDetailedIssueData;
import com.klocwork.kwjenkinsplugin.dto.HtmlReportIssues;
import com.klocwork.kwjenkinsplugin.dto.KlocworkJsonIssue;
import com.klocwork.kwjenkinsplugin.reporting.Messages;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class KlocworkResultsAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> build;
    private final String url;
    private final String text;
    private final String icon;
    private final transient Launcher launcher;
    private final transient EnvVars envVars;
    private final transient TaskListener listener;
    private final transient String remotePath;
    private final transient VirtualChannel channel;
    private final transient KlocworkFailureConditionConfig failureConditionConfig;
    private List<HtmlDetailedIssueData> htmlIssues = new ArrayList<HtmlDetailedIssueData>();
    private static final Logger LOGGER = Logger.getLogger(KlocworkResultsAction.class.getName());

    public KlocworkResultsAction(Run<?, ?> build, String remote, VirtualChannel channel, Launcher launcher, EnvVars envVars, TaskListener listener, KlocworkFailureConditionConfig failureConditionConfig) {
        this.build = build;
        this.launcher = launcher;
        this.envVars = envVars;
        this.failureConditionConfig = failureConditionConfig;
        this.listener = listener;
        this.channel = channel;
        this.remotePath = remote;
        this.url = "KlocworkResultsAction";
        this.text = Messages.KlocworkDashboard_klocwork_results();
        this.icon = "/plugin/klocwork/icons/klocwork-24.gif";
        try {
            this.updateIssues();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage());
        }
    }

    private List<HtmlDetailedIssueData> initHtmlIssues(List<KlocworkJsonIssue> jsonIssues) {
        return jsonIssues.stream().map(HtmlDetailedIssueData::fromJsonIssue).collect(Collectors.toList());
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<KlocworkResultsAction> projectActions = new ArrayList<KlocworkResultsAction>();
        projectActions.add(this);
        return projectActions;
    }

    public String getIconFileName() {
        return this.icon;
    }

    public String getDisplayName() {
        return this.text;
    }

    public String getUrlName() {
        return this.url;
    }

    public HtmlReportIssues getResults() {
        HtmlReportIssues report = new HtmlReportIssues();
        if (this.htmlIssues == null || this.htmlIssues.isEmpty()) {
            return report;
        }
        Map<String, List<HtmlDetailedIssueData>> sortedIssues = this.htmlIssues.stream().collect(Collectors.groupingBy(HtmlDetailedIssueData::getState));
        if (sortedIssues.get(State.NEW.toString()) != null) {
            report.setNewIssues(sortedIssues.get(State.NEW.toString()).size());
            report.setNewIssuesData(sortedIssues.get(State.NEW.toString()));
        }
        if (sortedIssues.get(State.FIXED.text()) != null) {
            report.setFixedIssues(sortedIssues.get(State.FIXED.toString()).size());
            report.setFixedIssuesData(sortedIssues.get(State.FIXED.toString()));
        }
        int filesCount = this.htmlIssues.stream().collect(Collectors.groupingBy(HtmlDetailedIssueData::getFile)).size();
        report.setNewIssuesFiles(filesCount);
        return report;
    }

    private void updateIssues() throws IOException {
        LinkedHashSet<KlocworkJsonIssue> allIssues = new LinkedHashSet<KlocworkJsonIssue>();
        if (this.failureConditionConfig == null) {
            return;
        }
        if (this.failureConditionConfig.getFailureConditionCiConfigs() != null) {
            Iterator<KlocworkFailureConditionCiConfig> iterator = this.failureConditionConfig.getFailureConditionCiConfigs().iterator();
            while (iterator.hasNext()) {
                FilePath workspace = new FilePath(this.channel, this.remotePath);
                KlocworkFailureConditionCiConfig failureConfig = iterator.next();
                ArgumentListBuilder listCommand = this.getListCmd(failureConfig.getEnabledSeverites(), failureConfig.getEnabledStatuses(), workspace, "json");
                Map<KlocworkUtil.StreamReferences, ByteArrayOutputStream> response = KlocworkUtil.executeCommandParseOutput(this.launcher, workspace, this.envVars, listCommand);
                if (response.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).size() > 0) {
                    throw new IOException(response.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).toString());
                }
                List<KlocworkJsonIssue> jsonIssues = this.parseIssues(response.get((Object)KlocworkUtil.StreamReferences.OUT_STREAM));
                allIssues.addAll(jsonIssues);
            }
        }
        this.htmlIssues = this.initHtmlIssues(Lists.newArrayList(allIssues.iterator()));
    }

    private List<KlocworkJsonIssue> parseIssues(ByteArrayOutputStream jsonStream) {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(jsonStream.toByteArray()));
        JsonReader jsonReader = new JsonReader((Reader)reader);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return (List)gson.fromJson(jsonReader, new TypeToken<List<KlocworkJsonIssue>>(){}.getType());
    }

    @JavaScriptMethod
    public JSONObject citeIssue(int issueId, int status, String comment) {
        LOGGER.log(Level.INFO, Messages.KlocworkResultAction_logger_cite_start(issueId));
        JSONObject result = new JSONObject();
        result.put("result", (Object)false);
        try {
            if (this.remotePath == null) {
                LOGGER.log(Level.WARNING, Messages.KlocworkResultAction_logger_cite_fails(issueId, Messages.KlocworkResultAction_oldbuild_error()));
                result.put("error", (Object)Messages.KlocworkResultAction_oldbuild_error());
                return result;
            }
            if (comment.length() > 150) {
                LOGGER.log(Level.WARNING, Messages.KlocworkResultAction_logger_cite_fails(issueId, Messages.KlocworkResultAction_comment_error()));
                result.put("error", (Object)Messages.KlocworkResultAction_comment_error());
                return result;
            }
            FilePath workspace = new FilePath(this.channel, this.remotePath);
            ArgumentListBuilder setStatusCommand = this.getSetStatusCmd(issueId, Status.getValue(status), comment, workspace);
            LOGGER.info("Running: " + setStatusCommand.toString());
            Map<KlocworkUtil.StreamReferences, ByteArrayOutputStream> response = KlocworkUtil.executeCommandParseOutput(this.launcher, workspace, this.envVars, setStatusCommand);
            if (response.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).size() > 0) {
                LOGGER.log(Level.WARNING, Messages.KlocworkResultAction_logger_cite_fails(issueId, response.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM)));
                result.put("error", (Object)response.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).toString());
                return result;
            }
            LOGGER.log(Level.INFO, Messages.KlocworkResultAction_logger_cite_success(issueId));
            result.put("result", (Object)true);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage() != null ? e.getMessage() : Messages.KlocworkResultAction_unknown_error();
            LOGGER.log(Level.WARNING, Messages.KlocworkResultAction_logger_cite_fails(issueId, errorMessage));
            result.put("error", (Object)errorMessage);
            return result;
        }
        try {
            this.updateIssues();
        }
        catch (IOException e) {
            result.put("error", (Object)e.getMessage());
        }
        return result;
    }

    public ArgumentListBuilder getSetStatusCmd(int issueId, Status status, String comment, FilePath workspace) {
        String ciTool = "kwciagent";
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{"kwciagent", "set-status"});
        command.add((Object)issueId);
        command.add(new String[]{"-s", status.getName()});
        if (!comment.isEmpty()) {
            command.add(new String[]{"-c", comment});
        }
        command.add(new String[]{"-pd", this.getKwlpDir(workspace, this.envVars).getRemote()});
        return command;
    }

    public ArgumentListBuilder getListCmd(KlocworkSeverities severities, KlocworkStatuses statuses, FilePath workspace, String outputFormat) {
        String severityString;
        String ciTool = "kwciagent";
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{"kwciagent", "list"});
        String statusString = statuses.getEnabled().keySet().stream().filter(status -> statuses.getEnabled().getOrDefault(status, false)).collect(Collectors.joining(","));
        if (!statusString.isEmpty()) {
            command.add(new String[]{"--status", statusString});
        }
        if (!(severityString = severities.getEnabled().keySet().stream().filter(severity -> severities.getEnabled().getOrDefault(severity, false)).map(severity -> this.getSeveritiesString((String)severity)).collect(Collectors.joining(","))).isEmpty()) {
            command.add(new String[]{"--severity", severityString});
        }
        command.add(new String[]{"-pd", this.getKwlpDir(workspace, this.envVars).getRemote()});
        if (!outputFormat.isEmpty()) {
            command.add(new String[]{"-F", outputFormat});
        }
        return command;
    }

    private String getSeveritiesString(String severityKey) {
        String FIVE_TO_TEN_SEVERITY = "fiveToTen";
        StringBuilder result = new StringBuilder();
        if (severityKey.equalsIgnoreCase("fiveToTen")) {
            for (int i = 5; i <= 10; ++i) {
                result.append(i);
                if (i >= 10) continue;
                result.append(",");
            }
        } else {
            result.append(Severity.valueOf(severityKey.toUpperCase()).getId());
        }
        return result.toString();
    }

    private FilePath getKwlpDir(FilePath workspace, EnvVars envVars) {
        return new FilePath(workspace.child(envVars.expand(workspace.getRemote())), ".kwlp");
    }

    public JSONObject getKlocworkStatusValues() {
        JSONObject statusValues = new JSONObject();
        for (Status status : Status.values()) {
            statusValues.put(status.getName(), (Object)status.getId());
        }
        return statusValues;
    }
}

