/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.reporting;

import com.klocwork.kwjenkinsplugin.definitions.KlocworkIssue;
import com.klocwork.kwjenkinsplugin.reporting.Messages;
import hudson.model.Action;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;

public class KlocworkDashboard
implements Action,
SimpleBuildStep.LastBuildAction {
    private static final Logger debugLogger = Logger.getLogger(KlocworkDashboard.class.getName());
    public final String url;
    public final String text;
    public final String icon;
    public final List<? extends KlocworkIssue> localIssues;
    public final List<KlocworkIssue> serverIssues;
    public final boolean shouldDashboardLocal;
    public final boolean shouldDashboardServer;

    public KlocworkDashboard(List<? extends KlocworkIssue> localIssues, List<KlocworkIssue> serverIssues, boolean shouldDashboardLocal, boolean shouldDashboardServer) {
        debugLogger.fine("[" + this.getClass().getName() + "] - Constructing the dashboard");
        this.shouldDashboardLocal = shouldDashboardLocal;
        this.shouldDashboardServer = shouldDashboardServer;
        this.url = "KlocworkDashboard";
        this.text = Messages.KlocworkDashboard_klocwork_dashboard();
        this.icon = "/plugin/klocwork/icons/klocwork-24.gif";
        this.localIssues = localIssues;
        this.serverIssues = serverIssues;
    }

    public String getUrlName() {
        return this.url;
    }

    public String getDisplayName() {
        return this.text;
    }

    public String getIconFileName() {
        return this.icon;
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public List<? extends KlocworkIssue> getLocalIssues() {
        return this.localIssues;
    }

    public String getLocalIssuesSize() {
        return String.valueOf(this.localIssues.size());
    }

    public List<KlocworkIssue> getServerIssues() {
        return this.serverIssues;
    }

    public String getServerIssuesSize() {
        return String.valueOf(this.serverIssues.size());
    }

    public boolean isShouldDashboardLocal() {
        return this.shouldDashboardLocal;
    }

    public boolean isShouldDashboardServer() {
        return this.shouldDashboardServer;
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<KlocworkDashboard> projectActions = new ArrayList<KlocworkDashboard>();
        projectActions.add(new KlocworkDashboard(this.localIssues, this.serverIssues, this.shouldDashboardLocal, this.shouldDashboardServer));
        return projectActions;
    }
}

