/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.pipeline;

import com.google.inject.Inject;
import com.klocwork.kwjenkinsplugin.KlocworkBuildSpecBuilder;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.config.KlocworkBuildSpecConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkBuildSpecStep
extends AbstractStepImpl {
    private KlocworkBuildSpecConfig buildSpecConfig;

    @DataBoundConstructor
    public KlocworkBuildSpecStep(KlocworkBuildSpecConfig buildSpecConfig) {
        this.buildSpecConfig = buildSpecConfig;
    }

    public KlocworkBuildSpecConfig getBuildSpecConfig() {
        return this.buildSpecConfig;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KlocworkBuildSpecStepExecution.class);
        }

        public String getFunctionName() {
            return "klocworkBuildSpecGeneration";
        }

        @Nonnull
        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_BUILD_SPEC_DISPLAY_NAME;
        }
    }

    private static class KlocworkBuildSpecStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient KlocworkBuildSpecStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private KlocworkBuildSpecStepExecution() {
        }

        protected Void run() throws Exception {
            KlocworkBuildSpecBuilder builder = new KlocworkBuildSpecBuilder(this.step.getBuildSpecConfig());
            builder.perform(this.build, this.env, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

