/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.config.Messages;
import com.klocwork.kwjenkinsplugin.services.KlocworkApiConnection;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KlocworkXSyncConfig
extends AbstractDescribableImpl<KlocworkXSyncConfig> {
    private final boolean dryRun;
    private final String lastSync;
    private final String projectRegexp;
    private final boolean statusAnalyze;
    private final boolean statusIgnore;
    private final boolean statusNotAProblem;
    private final boolean statusFix;
    private final boolean statusFixInNextRelease;
    private final boolean statusFixInLaterRelease;
    private final boolean statusDefer;
    private final boolean statusFilter;
    private final String additionalOpts;

    @DataBoundConstructor
    public KlocworkXSyncConfig(boolean dryRun, String lastSync, String projectRegexp, boolean statusAnalyze, boolean statusIgnore, boolean statusNotAProblem, boolean statusFix, boolean statusFixInNextRelease, boolean statusFixInLaterRelease, boolean statusDefer, boolean statusFilter, String additionalOpts) {
        this.dryRun = dryRun;
        this.lastSync = lastSync;
        this.projectRegexp = projectRegexp;
        this.statusAnalyze = statusAnalyze;
        this.statusIgnore = statusIgnore;
        this.statusNotAProblem = statusNotAProblem;
        this.statusFix = statusFix;
        this.statusFixInNextRelease = statusFixInNextRelease;
        this.statusFixInLaterRelease = statusFixInLaterRelease;
        this.statusDefer = statusDefer;
        this.statusFilter = statusFilter;
        this.additionalOpts = additionalOpts;
    }

    public ArgumentListBuilder getVersionCmd() {
        ArgumentListBuilder versionCmd = new ArgumentListBuilder(new String[]{"kwxsync"});
        versionCmd.add("--version");
        return versionCmd;
    }

    public ArgumentListBuilder getxsyncCmd(EnvVars envVars, Launcher launcher) throws AbortException {
        ArgumentListBuilder xsyncCmd = new ArgumentListBuilder(new String[]{"kwxsync"});
        String projectList = this.getProjectList(envVars, launcher);
        String lastSyncArg = this.getLastSyncDateDiff();
        xsyncCmd.add(new String[]{"--url", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL)});
        xsyncCmd.add(new String[]{"--last-sync", lastSyncArg});
        if (this.dryRun) {
            xsyncCmd.add("--dry");
        }
        ArrayList<String> statuses = new ArrayList<String>();
        if (this.statusAnalyze) {
            statuses.add("Analyze");
        }
        if (this.statusIgnore) {
            statuses.add("Ignore");
        }
        if (this.statusNotAProblem) {
            statuses.add("Not a Problem");
        }
        if (this.statusFix) {
            statuses.add("Fix");
        }
        if (this.statusFixInNextRelease) {
            statuses.add("Fix in Next Release");
        }
        if (this.statusFixInLaterRelease) {
            statuses.add("Fix in Later Release");
        }
        if (this.statusDefer) {
            statuses.add("Defer");
        }
        if (this.statusFilter) {
            statuses.add("Filter");
        }
        if (statuses.size() > 0) {
            xsyncCmd.add("--statuses");
            xsyncCmd.add(StringUtils.join(statuses, (String)"\",\""));
        }
        if (!StringUtils.isEmpty((CharSequence)this.additionalOpts)) {
            xsyncCmd.addTokenized(envVars.expand(this.additionalOpts));
        }
        xsyncCmd.addTokenized(projectList);
        return xsyncCmd;
    }

    private String getProjectList(EnvVars envVars, Launcher launcher) throws AbortException {
        JSONArray response;
        StringBuilder projectList = new StringBuilder();
        String request = "action=projects";
        try {
            String[] ltokenLine = KlocworkUtil.getLtokenValues(envVars, launcher);
            KlocworkApiConnection kwService = new KlocworkApiConnection((String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL), ltokenLine[2], ltokenLine[3]);
            response = kwService.sendRequest(request);
        }
        catch (IOException ex) {
            throw new AbortException("Error: failed to connect to the Klocwork web API.\nMessage: " + ex.getMessage());
        }
        Pattern p = Pattern.compile(this.projectRegexp);
        for (int i = 0; i < response.size(); ++i) {
            JSONObject jObj = response.getJSONObject(i);
            Matcher m = p.matcher(jObj.getString("name"));
            if (!m.find()) continue;
            projectList.append("\"" + jObj.getString("name") + "\"");
            projectList.append(" ");
        }
        if (StringUtils.isEmpty((CharSequence)projectList)) {
            throw new AbortException("Could not match any projects on server " + (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL) + " with regular expression \"" + this.projectRegexp + "\"");
        }
        return projectList.toString();
    }

    private String getLastSyncDateDiff() throws NumberFormatException, AbortException {
        Pattern p = Pattern.compile("^([0-9][0-9])-([0-9][0-9])-([0-9][0-9][0-9][0-9]) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
        Matcher m = p.matcher(this.lastSync);
        if (!m.find()) {
            throw new AbortException("Error: Could not match Last Sync value " + this.lastSync + " using regular expression. Please check date/time format on job config.");
        }
        DateTime date = new DateTime((Object)new Date());
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm:ss");
        if (!this.isStringNumZero(m.group(1))) {
            date = date.minusDays(Integer.valueOf(m.group(1)).intValue());
        }
        if (!this.isStringNumZero(m.group(2))) {
            date = date.minusMonths(Integer.valueOf(m.group(2)).intValue());
        }
        if (!this.isStringNumZero(m.group(3))) {
            date = date.minusYears(Integer.valueOf(m.group(3)).intValue());
        }
        if (!this.isStringNumZero(m.group(4))) {
            date = date.minusHours(Integer.valueOf(m.group(4)).intValue());
        }
        if (!this.isStringNumZero(m.group(5))) {
            date = date.minusMinutes(Integer.valueOf(m.group(5)).intValue());
        }
        if (!this.isStringNumZero(m.group(6))) {
            date = date.minusSeconds(Integer.valueOf(m.group(6)).intValue());
        }
        return dtf.print((ReadableInstant)date);
    }

    private boolean isStringNumZero(String num) {
        return num.trim().matches("0+");
    }

    public boolean getDryRun() {
        return this.dryRun;
    }

    public String getLastSync() {
        return this.lastSync;
    }

    public String getProjectRegexp() {
        return this.projectRegexp;
    }

    public boolean getStatusAnalyze() {
        return this.statusAnalyze;
    }

    public boolean getStatusIgnore() {
        return this.statusIgnore;
    }

    public boolean getStatusNotAProblem() {
        return this.statusNotAProblem;
    }

    public boolean getStatusFix() {
        return this.statusFix;
    }

    public boolean getStatusFixInNextRelease() {
        return this.statusFixInNextRelease;
    }

    public boolean getStatusFixInLaterRelease() {
        return this.statusFixInLaterRelease;
    }

    public boolean getStatusDefer() {
        return this.statusDefer;
    }

    public boolean getStatusFilter() {
        return this.statusFilter;
    }

    public String getAdditionalOpts() {
        return this.additionalOpts;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkXSyncConfig> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckLastSync(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.error((String)Messages.KlocworkXSyncConfig_last_sync_mandatory());
            }
            Pattern p = Pattern.compile("^([0-9][0-9])-([0-9][0-9])-([0-9][0-9][0-9][0-9]) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
            Matcher m = p.matcher(value);
            if (!m.find()) {
                return FormValidation.error((String)("Error: Could not match Last Sync value " + value + " using regular expression. Please check date/time format on job config."));
            }
            return FormValidation.ok();
        }
    }
}

