/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkFailureConditionServerConfig
extends AbstractDescribableImpl<KlocworkFailureConditionServerConfig> {
    private final String jobResult;
    private final String query;
    private final String threshold;
    private final String conditionName;
    private final boolean stopBuild;
    private final boolean enableHTMLReporting;

    public boolean isEnableHTMLReporting() {
        return this.enableHTMLReporting;
    }

    @DataBoundConstructor
    public KlocworkFailureConditionServerConfig(String jobResult, String query, String threshold, String conditionName, boolean stopBuild, boolean enableHTMLReporting) {
        this.jobResult = jobResult;
        this.query = query;
        this.threshold = threshold;
        this.conditionName = conditionName;
        this.stopBuild = stopBuild;
        this.enableHTMLReporting = enableHTMLReporting;
    }

    public String toString() {
        return "[ jobResult:" + this.jobResult + ", query:" + this.query + ", threshold:" + this.threshold + ", conditionName:" + this.conditionName + ", stopBuild:" + this.stopBuild + ", enableHTMLReporting:" + this.enableHTMLReporting + " ]";
    }

    public String getJobResult() {
        return this.jobResult;
    }

    public String getQuery() {
        return this.query;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public Result getResultValue() {
        switch (this.jobResult) {
            case "failure": {
                return Result.FAILURE;
            }
            case "unstable": {
                return Result.UNSTABLE;
            }
            case "pass": {
                return Result.SUCCESS;
            }
        }
        return Result.FAILURE;
    }

    public boolean getStopBuild() {
        return this.stopBuild;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkFailureConditionServerConfig> {
        public String getDisplayName() {
            return null;
        }
    }
}

