/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.config.KlocworkDifferentialAnalysisConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Run;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkCiConfig
extends AbstractDescribableImpl<KlocworkCiConfig> {
    private final String buildSpec;
    private final String projectDir;
    private final boolean cleanupProject;
    private final String reportFile;
    private final String additionalOpts;
    private final boolean incrementalAnalysis;
    private final KlocworkDifferentialAnalysisConfig differentialAnalysisConfig;
    private static final String ciTool = "kwciagent";
    @Deprecated
    private static final String oldTool = "kwcheck";
    private static final String GIT_PREVIOUS_COMMIT = "GIT_PREVIOUS_COMMIT";
    private static final Logger debugLogger = Logger.getLogger(KlocworkCiConfig.class.getName());

    @DataBoundConstructor
    public KlocworkCiConfig(String buildSpec, String projectDir, boolean cleanupProject, String reportFile, String additionalOpts, boolean incrementalAnalysis, KlocworkDifferentialAnalysisConfig differentialAnalysisConfig) {
        this.buildSpec = buildSpec;
        this.projectDir = projectDir;
        this.cleanupProject = cleanupProject;
        this.reportFile = reportFile;
        this.additionalOpts = additionalOpts;
        this.incrementalAnalysis = incrementalAnalysis;
        this.differentialAnalysisConfig = differentialAnalysisConfig;
    }

    public static ArgumentListBuilder getVersionCiAgentCmd() throws IOException, InterruptedException {
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{ciTool});
        command.add("--version");
        return command;
    }

    public static ArgumentListBuilder getVersionKwCheckCmd() throws IOException, InterruptedException {
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{oldTool});
        command.add("--version");
        return command;
    }

    public ArgumentListBuilder getCiToolCreateCmd(EnvVars envVars, FilePath workspace) throws IOException, InterruptedException {
        KlocworkCiConfig.validateParentProjectDir(this.getKwlpDir(workspace, envVars).getParent());
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{ciTool, "create"});
        String projectUrl = KlocworkUtil.getKlocworkProjectUrl(envVars);
        if (!StringUtils.isEmpty((CharSequence)projectUrl)) {
            command.add(new String[]{"--url", projectUrl});
        }
        command.add(new String[]{"--project-dir", this.getKwlpDir(workspace, envVars).getRemote()});
        command.add(new String[]{"--settings-dir", this.getKwpsDir(workspace, envVars).getRemote()});
        command.add(new String[]{"--build-spec", envVars.expand(KlocworkUtil.getDefaultBuildSpec(this.buildSpec))});
        return command;
    }

    public ArgumentListBuilder getCiToolSetCmd(EnvVars envVars, FilePath workspace) throws IOException, InterruptedException {
        KlocworkCiConfig.validateParentProjectDir(this.getKwlpDir(workspace, envVars).getParent());
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{ciTool, "set"});
        command.add(new String[]{"--project-dir", this.getKwlpDir(workspace, envVars).getRemote()});
        String serverUrl = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL);
        if (!StringUtils.isEmpty((CharSequence)serverUrl)) {
            URL url = new URL(serverUrl);
            command.add("klocwork.host=" + url.getHost());
            command.add("klocwork.port=" + Integer.toString(url.getPort()));
            command.add("klocwork.project=" + (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT));
        }
        return command;
    }

    public ArgumentListBuilder getCiToolListCmd(EnvVars envVars, FilePath workspace, String diffList, String outputFormat) throws IOException, InterruptedException {
        String licensePort;
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{ciTool, "list"});
        command.add(new String[]{"--project-dir", this.getKwlpDir(workspace, envVars).getRemote()});
        String licenseHost = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_HOST);
        if (!StringUtils.isEmpty((CharSequence)licenseHost)) {
            command.add(new String[]{"--license-host", licenseHost});
        }
        if (!StringUtils.isEmpty((CharSequence)(licensePort = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_PORT)))) {
            command.add(new String[]{"--license-port", licensePort});
        }
        command.add(new String[]{"-F", outputFormat});
        if (!StringUtils.isEmpty((CharSequence)this.additionalOpts)) {
            command.addTokenized(envVars.expand(this.additionalOpts));
        }
        if (!StringUtils.isEmpty((CharSequence)diffList)) {
            command.add("@" + diffList);
        }
        return command;
    }

    public ArgumentListBuilder getCiToolRunCmd(EnvVars envVars, FilePath workspace, String diffList) throws IOException, InterruptedException {
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{ciTool, "run"});
        command.add(new String[]{"--project-dir", this.getKwlpDir(workspace, envVars).getRemote()});
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_HOST)))) {
            command.add(new String[]{"--license-host", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_HOST)});
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_PORT)))) {
                command.add(new String[]{"--license-port", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_PORT)});
            }
        }
        command.add(new String[]{"-Y", "-L"});
        command.add(new String[]{"--build-spec", envVars.expand(KlocworkUtil.getDefaultBuildSpec(this.buildSpec))});
        if (!StringUtils.isEmpty((CharSequence)this.additionalOpts)) {
            command.addTokenized(envVars.expand(this.additionalOpts));
        }
        if (!StringUtils.isEmpty((CharSequence)diffList)) {
            command.add("@" + diffList);
        }
        return command;
    }

    public ArgumentListBuilder getGitDiffCmd(EnvVars envVars) {
        ArgumentListBuilder command = new ArgumentListBuilder(new String[]{"git"});
        command.add(new String[]{"diff", "--name-only", envVars.expand(this.differentialAnalysisConfig.getGitPreviousCommit())});
        command.add(new String[]{">", this.getDiffFileList(envVars)});
        return command;
    }

    public boolean hasPreviousCommitConfig(EnvVars envVars) {
        String commit = envVars.expand(this.differentialAnalysisConfig.getGitPreviousCommit());
        if (commit.isEmpty()) {
            debugLogger.warning(String.format("Git previous commit is empty", commit));
            return false;
        }
        if (commit.contains(GIT_PREVIOUS_COMMIT)) {
            debugLogger.warning(String.format("Git commit variable [%s] is not set.", commit));
            return false;
        }
        return true;
    }

    public boolean hasExistingProject(FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        FilePath kwlp = this.getKwlpDir(workspace, envVars);
        FilePath kwps = this.getKwpsDir(workspace, envVars);
        if (this.cleanupProject) {
            KlocworkCiConfig.cleanupExistingProject(kwlp, kwps);
        }
        if (kwlp.exists()) {
            if (kwps.exists()) {
                return true;
            }
            KlocworkCiConfig.cleanupExistingProject(kwlp, kwps);
            return false;
        }
        if (kwps.exists()) {
            KlocworkCiConfig.cleanupExistingProject(kwlp, kwps);
            return false;
        }
        return false;
    }

    private static void validateParentProjectDir(FilePath dir) throws IOException, InterruptedException {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private FilePath getKwlpDir(FilePath workspace, EnvVars envVars) {
        return new FilePath(workspace.child(envVars.expand(this.projectDir)), ".kwlp");
    }

    private FilePath getKwpsDir(FilePath workspace, EnvVars envVars) {
        return new FilePath(workspace.child(envVars.expand(this.projectDir)), ".kwps");
    }

    private static void cleanupExistingProject(FilePath kwlp, FilePath kwps) throws IOException, InterruptedException {
        if (kwlp.exists()) {
            kwlp.deleteRecursive();
        }
        if (kwps.exists()) {
            kwps.deleteRecursive();
        }
    }

    public String getDiffFileList(EnvVars envVars) {
        return envVars.expand(this.differentialAnalysisConfig.getDiffFileList());
    }

    public boolean isGitDiffType() {
        return this.differentialAnalysisConfig.isGitDiffType();
    }

    public String getBuildSpec() {
        return this.buildSpec;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public boolean getCleanupProject() {
        return this.cleanupProject;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public String getAdditionalOpts() {
        return this.additionalOpts;
    }

    public boolean getIncrementalAnalysis() {
        return this.incrementalAnalysis;
    }

    public KlocworkDifferentialAnalysisConfig getDifferentialAnalysisConfig() {
        return this.differentialAnalysisConfig;
    }

    public static String getCiTool() {
        return ciTool;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkCiConfig> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.config.KlocworkDesktopConfig", KlocworkCiConfig.class);
            Run.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.config.KlocworkDesktopConfig", KlocworkCiConfig.class);
        }

        public String getDisplayName() {
            return null;
        }
    }
}

