/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ArgumentListBuilder;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkBuildSpecConfig
extends AbstractDescribableImpl<KlocworkBuildSpecConfig> {
    private final String buildCommand;
    private final String tool;
    private final String output;
    private final String additionalOpts;
    private final boolean ignoreErrors;

    @DataBoundConstructor
    public KlocworkBuildSpecConfig(String buildCommand, String tool, String output, String additionalOpts, boolean ignoreErrors) {
        this.buildCommand = buildCommand;
        this.tool = tool;
        this.output = output;
        this.additionalOpts = additionalOpts;
        this.ignoreErrors = ignoreErrors;
    }

    public ArgumentListBuilder getVersionCmd() {
        ArgumentListBuilder versionCmd = new ArgumentListBuilder(new String[]{this.getTool()});
        versionCmd.add("--version");
        return versionCmd;
    }

    public ArgumentListBuilder getToolCmd(EnvVars envVars) {
        ArgumentListBuilder toolCmd = new ArgumentListBuilder();
        if (this.getTool().equals("kwtrace")) {
            toolCmd.add(new String[]{"kwinject", "-T"});
            if (!StringUtils.isEmpty((CharSequence)this.getOutput())) {
                toolCmd.add(new String[]{"--trace-out", this.getOutput()});
            }
        } else {
            toolCmd.add(this.getTool());
            if (!StringUtils.isEmpty((CharSequence)this.getOutput())) {
                toolCmd.add(new String[]{"--output", this.getOutput()});
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.getAdditionalOpts())) {
            toolCmd.addTokenized(envVars.expand(this.getAdditionalOpts()));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getBuildCommand())) {
            toolCmd.addTokenized(envVars.expand(this.getBuildCommand()));
        }
        return toolCmd;
    }

    public String getTool() {
        return this.tool;
    }

    public String getOutput() {
        return this.output;
    }

    public String getAdditionalOpts() {
        return this.additionalOpts;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkBuildSpecConfig> {
        public String getDisplayName() {
            return null;
        }
    }
}

