/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkXSyncConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkXSyncBuilder
extends Builder
implements SimpleBuildStep {
    private final KlocworkXSyncConfig syncConfig;

    @DataBoundConstructor
    public KlocworkXSyncBuilder(KlocworkXSyncConfig syncConfig) {
        this.syncConfig = syncConfig;
    }

    public KlocworkXSyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        KlocworkLogger logger = new KlocworkLogger("XSyncBuilder", listener.getLogger());
        logger.logMessage("Starting Klocwork Cross Synchronisation Step");
        KlocworkUtil.validateServerURL(envVars);
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.syncConfig.getVersionCmd());
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.syncConfig.getxsyncCmd(envVars, launcher));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_XSYNC_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

