/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkProjectAction;
import com.klocwork.kwjenkinsplugin.config.KlocworkReportConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;

public class KlocworkBuildAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;
    private final int criticalCount;
    private final int errorCount;
    private final int warningCount;
    private final int reviewCount;
    private final String buildName;
    private final String klocworkURL;
    private final String klocworkProject;
    private final KlocworkReportConfig reportConfig;
    private final String projectId;

    public KlocworkBuildAction(Run<?, ?> run, Map<String, Integer> severityMap, EnvVars envVars, String buildName, KlocworkReportConfig reportConfig) {
        this.run = run;
        this.criticalCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_CRITICAL, 0);
        this.errorCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_ERROR, 0);
        this.warningCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_WARNING, 0);
        this.reviewCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_REVIEW, 0);
        this.buildName = KlocworkUtil.getDefaultBuildName(buildName, envVars);
        this.klocworkURL = KlocworkUtil.getNormalizedKlocworkUrl(envVars);
        this.klocworkProject = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT);
        this.reportConfig = reportConfig;
        this.projectId = "";
    }

    public KlocworkBuildAction(Run<?, ?> run, Map<String, Integer> severityMap, EnvVars envVars, String buildName, KlocworkReportConfig reportConfig, String projectID) {
        this.run = run;
        this.criticalCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_CRITICAL, 0);
        this.errorCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_ERROR, 0);
        this.warningCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_WARNING, 0);
        this.reviewCount = severityMap.getOrDefault(KlocworkConstants.KLOCWORK_ISSUE_REVIEW, 0);
        this.buildName = KlocworkUtil.getDefaultBuildName(buildName, envVars);
        this.klocworkURL = KlocworkUtil.getNormalizedKlocworkUrl(envVars);
        this.klocworkProject = (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT);
        this.reportConfig = reportConfig;
        this.projectId = projectID;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getIconFileName() {
        return "/plugin/klocwork/icons/klocwork-24.gif";
    }

    public String getDisplayName() {
        return KlocworkConstants.DISPLAY_NAME;
    }

    public String getUrlName() {
        try {
            if (this.projectId == null || this.projectId.equals("")) {
                return KlocworkUtil.getBuildIssueListUrl(this.klocworkURL, this.klocworkProject, this.buildName);
            }
            return KlocworkUtil.getBuildIssueListUrl(this.klocworkURL, this.projectId, this.buildName);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public int getCriticalCount() {
        return this.criticalCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getReviewCount() {
        return this.reviewCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getKlocworkURL() {
        return this.klocworkURL;
    }

    public String getKlocworkProject() {
        return this.klocworkProject;
    }

    public boolean isDisplayChart() {
        return this.reportConfig.isDisplayChart();
    }

    public String getChartWidth() {
        return this.reportConfig.getChartWidth();
    }

    public String getChartHeight() {
        return this.reportConfig.getChartHeight();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<KlocworkProjectAction> projectActions = new ArrayList<KlocworkProjectAction>();
        projectActions.add(new KlocworkProjectAction(this.run.getParent()));
        return projectActions;
    }
}

