/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.util;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.client.KiuwanClientException;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.client.KiuwanClientUtils;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import com.kiuwan.rest.client.ApiClient;
import com.kiuwan.rest.client.ApiException;
import com.kiuwan.rest.client.api.InformationApi;
import com.kiuwan.rest.client.model.UserInformationResponse;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class KiuwanAnalyzerInstaller {
    private static final String KIUWAN_CLOUD_DOWNLOAD_URL = "https://static.kiuwan.com/download";
    private static final String KIUWAN_LOCAL_ANALYZER_DOWNLOAD_FILE = "/analyzer/KiuwanLocalAnalyzer.zip";
    private static final String KIUWAN_LOCAL_ANALYZER_VERSION_DOWNLOAD_FILE = "/analyzer/agent.version";
    private static final String KIUWAN_LOCAL_ANALYZER_ENGINE_DOWNLOAD_FILE = "/analyzer/engine_%s.zip";
    private static final String KIUWAN_LOCAL_ANALYZER_ENGINE_VERSION_DOWNLOAD_FILE = "/analyzer/engine.version";
    private static final String LOCAL_ANALYZER_DIRECTORY = "KiuwanLocalAnalyzer";
    private static final String ENGINE_DIRECTORY = "engine";

    public static String getCurrentKlaVersion(boolean configureKiuwanURL, String kiuwanURL) throws IOException {
        KiuwanConnectionProfile connectionProfile = new KiuwanConnectionProfile();
        connectionProfile.setConfigureKiuwanURL(configureKiuwanURL);
        connectionProfile.setKiuwanURL(kiuwanURL);
        URL klaVersionURL = KiuwanAnalyzerInstaller.getDownloadURL(connectionProfile, KIUWAN_LOCAL_ANALYZER_VERSION_DOWNLOAD_FILE);
        return KiuwanAnalyzerInstaller.downloadToString(klaVersionURL);
    }

    public static FilePath installKiuwanLocalAnalyzer(FilePath rootDir, TaskListener listener, KiuwanConnectionProfile connectionProfile) throws IOException, InterruptedException {
        KiuwanUtils.logger().info("Begin installation process of KLA and Kiuwan engine for " + connectionProfile);
        String cachedKlaVersion = null;
        URL klaVersionURL = KiuwanAnalyzerInstaller.getDownloadURL(connectionProfile, KIUWAN_LOCAL_ANALYZER_VERSION_DOWNLOAD_FILE);
        File cachedKlaVersionFile = KiuwanAnalyzerInstaller.getLocalCacheFile(klaVersionURL, connectionProfile);
        if (cachedKlaVersionFile != null && cachedKlaVersionFile.exists()) {
            try (FileInputStream is = new FileInputStream(cachedKlaVersionFile);){
                cachedKlaVersion = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                KiuwanUtils.logger().info("Kiuwan Local Analyzer cached version = " + cachedKlaVersion);
            }
            catch (IOException e) {
                KiuwanUtils.logger().log(Level.INFO, "agent.version not found in cache for profile " + connectionProfile);
            }
        }
        boolean klaNeedsUpdate = true;
        if (cachedKlaVersion != null) {
            String remoteKlaVersion = KiuwanAnalyzerInstaller.downloadToString(klaVersionURL);
            KiuwanUtils.logger().info("Kiuwan Local Analyzer remote version = " + remoteKlaVersion);
            klaNeedsUpdate = !cachedKlaVersion.equals(remoteKlaVersion);
            listener.getLogger().println("Cached KLA version: " + cachedKlaVersion);
            listener.getLogger().println("Remote KLA version: " + remoteKlaVersion);
        }
        KiuwanUtils.logger().info("Kiuwan Local Analyzer needs update = " + klaNeedsUpdate);
        URL klaURL = KiuwanAnalyzerInstaller.getDownloadURL(connectionProfile, KIUWAN_LOCAL_ANALYZER_DOWNLOAD_FILE);
        File cachedKlaFile = KiuwanAnalyzerInstaller.getLocalCacheFile(klaURL, connectionProfile);
        if (klaNeedsUpdate) {
            String message = "Updating cached Kiuwan Local Analyzer from " + klaURL;
            listener.getLogger().println(message);
            KiuwanUtils.logger().info(message);
            cachedKlaVersionFile.delete();
            cachedKlaFile.delete();
            KiuwanAnalyzerInstaller.downloadToFile(klaURL, cachedKlaFile);
            KiuwanAnalyzerInstaller.downloadToFile(klaVersionURL, cachedKlaVersionFile);
        }
        String cachedEngineVersion = null;
        URL engineVersionURL = KiuwanAnalyzerInstaller.getDownloadURL(connectionProfile, KIUWAN_LOCAL_ANALYZER_ENGINE_VERSION_DOWNLOAD_FILE);
        File cachedEngineVersionFile = KiuwanAnalyzerInstaller.getLocalCacheFile(engineVersionURL, connectionProfile);
        if (cachedEngineVersionFile != null && cachedEngineVersionFile.exists()) {
            try (FileInputStream is = new FileInputStream(cachedEngineVersionFile);){
                cachedEngineVersion = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                KiuwanUtils.logger().info("Kiuwan Engine cached version = " + cachedEngineVersion);
            }
            catch (IOException e) {
                KiuwanUtils.logger().log(Level.INFO, "engine.version not found in cache for profile " + connectionProfile);
            }
        }
        boolean engineNeedsUpdate = true;
        String remoteEngineVersion = KiuwanAnalyzerInstaller.getCustomerEngineVersion(connectionProfile);
        KiuwanUtils.logger().info("Kiuwan Engine remote version = " + remoteEngineVersion);
        engineNeedsUpdate = cachedEngineVersion == null || !cachedEngineVersion.equals(remoteEngineVersion);
        KiuwanUtils.logger().info("Kiuwan Engine needs update = " + engineNeedsUpdate);
        listener.getLogger().println("Cached Engine version: " + (cachedEngineVersion == null ? "[NONE]" : cachedEngineVersion));
        listener.getLogger().println("Remote Engine version: " + remoteEngineVersion);
        String engineDownloadFileName = String.format(KIUWAN_LOCAL_ANALYZER_ENGINE_DOWNLOAD_FILE, remoteEngineVersion);
        URL engineURL = KiuwanAnalyzerInstaller.getDownloadURL(connectionProfile, engineDownloadFileName);
        File engineCacheFile = KiuwanAnalyzerInstaller.getLocalCacheFile(engineURL, connectionProfile);
        if (engineNeedsUpdate && remoteEngineVersion != null) {
            String message = "Updating cached Kiuwan Engine from " + engineURL;
            listener.getLogger().println(message);
            KiuwanUtils.logger().info(message);
            cachedEngineVersionFile.delete();
            engineCacheFile.delete();
            KiuwanAnalyzerInstaller.downloadToFile(engineURL, engineCacheFile);
            try (FileOutputStream os = new FileOutputStream(cachedEngineVersionFile);){
                IOUtils.write((String)remoteEngineVersion, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                KiuwanUtils.logger().log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
        String toolsRelativePath = KiuwanUtils.getToolsRelativePath(connectionProfile);
        FilePath nodeToolsDir = rootDir.child(toolsRelativePath);
        FilePath engineInstallDir = new FilePath(nodeToolsDir, ENGINE_DIRECTORY);
        FilePath klaHome = nodeToolsDir.child(LOCAL_ANALYZER_DIRECTORY);
        if (!klaHome.exists()) {
            listener.getLogger().println("Installing Kiuwan Local Analyzer for connection profile " + connectionProfile.getDisplayName() + " into " + nodeToolsDir);
            try {
                klaHome.mkdirs();
                if (engineCacheFile != null && engineCacheFile.exists()) {
                    FilePath engineCacheFilePath = new FilePath(engineCacheFile);
                    engineCacheFilePath.unzip(nodeToolsDir);
                    engineInstallDir.moveAllChildrenTo(klaHome);
                }
                FilePath klaCacheFilePath = new FilePath(cachedKlaFile);
                klaCacheFilePath.unzip(nodeToolsDir);
                if (klaHome.mode() != -1) {
                    for (FilePath shellScript : klaHome.list("**/*.sh")) {
                        listener.getLogger().println("Changing " + shellScript + " permissions");
                        shellScript.chmod(493);
                    }
                }
            }
            catch (IOException e) {
                if (engineInstallDir.exists()) {
                    try {
                        engineInstallDir.delete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (klaHome.exists()) {
                    try {
                        klaHome.delete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return klaHome;
    }

    private static URL getDownloadURL(KiuwanConnectionProfile connectionProfile, String file) throws MalformedURLException {
        String urlStr = null;
        if (!connectionProfile.isConfigureKiuwanURL()) {
            urlStr = KIUWAN_CLOUD_DOWNLOAD_URL;
        } else {
            URL url = new URL(connectionProfile.getKiuwanURL());
            String urlPort = url.getPort() != -1 ? ":" + url.getPort() : "";
            String baseURL = url.getProtocol() + "://" + url.getHost() + urlPort;
            urlStr = baseURL + "/pub";
        }
        URL downloadBaseURL = new URL(urlStr);
        URL downloadURL = new URL(downloadBaseURL.getProtocol(), downloadBaseURL.getHost(), downloadBaseURL.getPort(), downloadBaseURL.getFile() + file);
        return downloadURL;
    }

    private static File getLocalCacheFile(URL src, KiuwanConnectionProfile connectionProfile) throws MalformedURLException {
        String s = src.toExternalForm();
        String fileName = s.substring(s.lastIndexOf(47) + 1);
        File rootDir = Jenkins.getInstance().getRootDir();
        String cacheRelativePath = KiuwanUtils.getCacheRelativePath(connectionProfile);
        File parentDir = new File(rootDir, cacheRelativePath);
        return new File(parentDir, fileName);
    }

    private static String getCustomerEngineVersion(KiuwanConnectionProfile connectionProfile) {
        String remoteEngineVersion = null;
        try {
            ApiClient client = KiuwanClientUtils.instantiateClient(connectionProfile.isConfigureKiuwanURL(), connectionProfile.getKiuwanURL(), connectionProfile.getUsername(), connectionProfile.getPassword(), connectionProfile.getDomain());
            InformationApi infoApi = new InformationApi(client);
            UserInformationResponse userInfo = infoApi.getInformation();
            remoteEngineVersion = userInfo.getEngineVersion();
        }
        catch (ApiException e) {
            KiuwanClientException kce = KiuwanClientException.from(e);
            KiuwanUtils.logger().log(Level.SEVERE, kce.getLocalizedMessage());
        }
        return remoteEngineVersion;
    }

    private static String downloadToString(URL url) throws IOException {
        String output = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream in = ProxyConfiguration.open((URL)url).getInputStream();){
            output = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadToFile(URL url, File file) throws IOException {
        Path tmpPath = Files.createTempFile("kiuwanJenkinsPlugin-", ".tmp", new FileAttribute[0]);
        File tmpFile = tmpPath.toFile();
        try (InputStream in = ProxyConfiguration.open((URL)url).getInputStream();){
            Files.copy(in, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            file.getParentFile().mkdirs();
            Files.move(tmpPath, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            tmpFile.delete();
        }
    }
}

