/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.util;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ChangeRequestStatusType;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.DeliveryType;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Measure;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Mode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyConfig;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyMode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class KiuwanAnalyzerCommandBuilder {
    private static final String AGENT_CONF_DIR_NAME = "conf";
    private static final String AGENT_PROPERTIES_FILE_NAME = "agent.properties";
    private static final String PROXY_PROTOCOL = "proxy.protocol";
    private static final String PROXY_HOST = "proxy.host";
    private static final String PROXY_PORT = "proxy.port";
    private static final String PROXY_AUTHENTICATION = "proxy.authentication";
    private static final String PROXY_USERNAME = "proxy.username";
    private static final String PROXY_PASSWORD = "proxy.password";
    private static final String proxyHostRegExp = "^\\s*proxy\\.host\\s*=.*$";
    private static final String proxyPortRegExp = "^\\s*proxy\\.port\\s*=.*$";
    private static final String proxyProtocolRegExp = "^\\s*proxy\\.protocol\\s*=.*$";
    private static final String proxyAuthenticationRegExp = "^\\s*proxy\\.authentication\\s*=.*$";
    private static final String proxyUsernameRegExp = "^\\s*proxy\\.username\\s*=.*$";
    private static final String proxyPasswordRegExp = "^\\s*proxy\\.password\\s*=.*$";
    private static final String kiuwanJenkinsPluginHeaderPrefix = "### KIUWAN JENKINS PLUGIN: ";
    private static final String kiuwanJenkinsPluginHeaderSuffix = " ###";
    private static final String kiuwanJenkinsPluginHeaderPattern = "### KIUWAN JENKINS PLUGIN: (.*) ###";
    private KiuwanRecorder recorder;
    private FilePath workspace;
    private KiuwanConnectionProfile connectionProfile;
    private KiuwanGlobalConfigDescriptor descriptor;
    private Run<?, ?> run;
    private Launcher launcher;
    private TaskListener listener;

    public KiuwanAnalyzerCommandBuilder(KiuwanRecorder recorder, FilePath workspace, KiuwanConnectionProfile connectionProfile, KiuwanGlobalConfigDescriptor descriptor, Run<?, ?> run, Launcher launcher, TaskListener listener) {
        this.recorder = recorder;
        this.workspace = workspace;
        this.connectionProfile = connectionProfile;
        this.descriptor = descriptor;
        this.run = run;
        this.launcher = launcher;
        this.listener = listener;
    }

    public List<String> buildLocalAnalyzerCommand(FilePath agentHome, EnvVars envVars) throws IOException, InterruptedException {
        String name = null;
        String analysisLabel = null;
        String analysisEncoding = null;
        if (Mode.DELIVERY_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            name = this.recorder.getApplicationName_dm();
            analysisLabel = this.recorder.getLabel_dm();
            analysisEncoding = this.recorder.getEncoding_dm();
        } else {
            name = this.recorder.getApplicationName();
            analysisLabel = this.recorder.getLabel();
            analysisEncoding = this.recorder.getEncoding();
        }
        if (StringUtils.isEmpty((String)name)) {
            name = this.run.getParent().getName();
        }
        if (StringUtils.isEmpty((String)analysisLabel)) {
            analysisLabel = "#" + this.run.getNumber();
        }
        if (StringUtils.isEmpty((String)analysisEncoding)) {
            analysisEncoding = "UTF-8";
        }
        Integer timeout = null;
        String includes = null;
        String excludes = null;
        String languages = null;
        if (Mode.DELIVERY_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            timeout = this.recorder.getTimeout_dm();
            includes = this.recorder.getIncludes_dm();
            excludes = this.recorder.getExcludes_dm();
            languages = this.recorder.getLanguages_dm();
        } else if (Mode.EXPERT_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            timeout = this.recorder.getTimeout_em();
        } else {
            timeout = this.recorder.getTimeout();
            includes = this.recorder.getIncludes();
            excludes = this.recorder.getExcludes();
            languages = this.recorder.getLanguages();
        }
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout.intValue(), TimeUnit.MINUTES);
        long timeoutSeconds = TimeUnit.SECONDS.convert(timeout.intValue(), TimeUnit.MINUTES);
        String timeoutAsStringMillis = Long.toString(timeoutMillis - KiuwanRecorder.TIMEOUT_MARGIN_MILLIS);
        String timeoutAsStringSeconds = Long.toString(timeoutSeconds - KiuwanRecorder.TIMEOUT_MARGIN_SECONDS);
        ArrayList<String> args = new ArrayList<String>();
        FilePath command = KiuwanAnalyzerCommandBuilder.getLocalAnalyzerCommandFilePath(this.launcher, agentHome);
        String commandAbsolutePath = KiuwanUtils.getRemoteFileAbsolutePath(command, this.listener);
        args.add(this.launcher.isUnix() ? commandAbsolutePath : "\"" + commandAbsolutePath + "\"");
        FilePath srcFolder = this.resolveSrcFolder();
        args.add("-s");
        args.add(KiuwanUtils.buildArgument(this.launcher, srcFolder.getRemote()));
        String outputFilename = this.recorder.getOutputFilename();
        if (StringUtils.isEmpty((String)outputFilename)) {
            outputFilename = "kiuwan/output.json";
        }
        FilePath outputFilePath = new FilePath(this.workspace, outputFilename);
        if (!KiuwanUtils.isDescendant(KiuwanUtils.getRemoteFile(this.workspace), KiuwanUtils.getRemoteFile(outputFilePath))) {
            throw new IOException("Specified outputFilename does not belong to current workspace");
        }
        args.add("-o");
        args.add(KiuwanUtils.buildArgument(this.launcher, outputFilePath.getRemote()));
        args.add("--user");
        args.add(KiuwanUtils.buildArgument(this.launcher, this.connectionProfile.getUsername()));
        args.add("--pass");
        args.add(KiuwanUtils.buildArgument(this.launcher, this.connectionProfile.getPassword()));
        String domain = this.connectionProfile.getDomain();
        if (StringUtils.isNotBlank((String)domain)) {
            args.add("--domain-id");
            args.add(KiuwanUtils.buildArgument(this.launcher, domain));
        }
        if (Mode.STANDARD_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            args.add("-n");
            args.add(KiuwanUtils.buildArgument(this.launcher, name));
            args.add("-l");
            args.add(KiuwanUtils.buildArgument(this.launcher, analysisLabel));
            args.add("-c");
            if (!Measure.NONE.getValue().equals(this.recorder.getMeasure())) {
                args.add("-wr");
            }
        } else if (Mode.DELIVERY_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            String changeRequestStatus;
            String branch;
            args.add("-n");
            args.add(KiuwanUtils.buildArgument(this.launcher, name));
            args.add("-l");
            args.add(KiuwanUtils.buildArgument(this.launcher, analysisLabel));
            args.add("-c");
            args.add("-cr");
            args.add(KiuwanUtils.buildArgument(this.launcher, this.recorder.getChangeRequest_dm()));
            args.add("-as");
            String deliveryType = this.recorder.getAnalysisScope_dm();
            if (DeliveryType.COMPLETE_DELIVERY.getValue().equals(deliveryType)) {
                deliveryType = "completeDelivery";
            } else if (DeliveryType.PARTIAL_DELIVERY.getValue().equals(deliveryType)) {
                deliveryType = "partialDelivery";
            }
            args.add(KiuwanUtils.buildArgument(this.launcher, deliveryType));
            if (this.recorder.getWaitForAuditResults_dm().booleanValue()) {
                args.add("-wr");
            }
            if (StringUtils.isNotBlank((String)(branch = this.recorder.getBranch_dm()))) {
                args.add("-bn");
                args.add(KiuwanUtils.buildArgument(this.launcher, branch));
            }
            if (StringUtils.isNotBlank((String)(changeRequestStatus = this.recorder.getChangeRequestStatus_dm()))) {
                args.add("-crs");
                changeRequestStatus = ChangeRequestStatusType.INPROGRESS.getValue().equals(changeRequestStatus) ? "inprogress" : "resolved";
                args.add(KiuwanUtils.buildArgument(this.launcher, changeRequestStatus));
            }
        } else if (Mode.EXPERT_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            this.parseOptions(args, this.launcher);
            this.parseParameters(args, this.launcher);
        }
        args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "timeout", timeoutAsStringMillis));
        args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "results.timeout", timeoutAsStringSeconds));
        if (!Mode.EXPERT_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            if (StringUtils.isNotBlank((String)includes)) {
                this.launcher.getListener().getLogger().println("Setting includes pattern -> " + includes);
                args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "include.patterns", includes));
            }
            if (StringUtils.isNotBlank((String)excludes)) {
                args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "exclude.patterns", excludes));
            }
            args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "encoding", analysisEncoding));
            if (Mode.STANDARD_MODE.getValue().equals(this.recorder.getSelectedMode()) && Boolean.TRUE.equals(this.recorder.getIndicateLanguages()) || Mode.DELIVERY_MODE.getValue().equals(this.recorder.getSelectedMode()) && Boolean.TRUE.equals(this.recorder.getIndicateLanguages_dm())) {
                args.add(KiuwanUtils.buildAdditionalParameterExpression(this.launcher, "supported.technologies", languages));
            }
        }
        FilePath agentBinDir = KiuwanAnalyzerCommandBuilder.getAgentBinDir(agentHome);
        this.writeConfigToProperties(agentBinDir);
        return args;
    }

    public static FilePath getAgentBinDir(FilePath agentHome) {
        return agentHome.child("bin");
    }

    public static String getLocalAnalyzerCommandFileName(Launcher launcher) {
        return launcher.isUnix() ? "agent.sh" : "agent.cmd";
    }

    public static FilePath getLocalAnalyzerCommandFilePath(Launcher launcher, FilePath agentHome) {
        String command = KiuwanAnalyzerCommandBuilder.getLocalAnalyzerCommandFileName(launcher);
        FilePath binDir = KiuwanAnalyzerCommandBuilder.getAgentBinDir(agentHome);
        FilePath script = binDir.child(command);
        return script;
    }

    public static boolean[] getMasks(List<String> args) {
        boolean[] masks = new boolean[args.size()];
        boolean mask = false;
        for (int i = 1; i < masks.length; ++i) {
            masks[i] = mask;
            if ("--user".equals(args.get(i)) || "--pass".equals(args.get(i))) {
                mask = true;
                continue;
            }
            if (args.get(i).contains("username") || args.get(i).contains("password")) {
                masks[i] = true;
                continue;
            }
            mask = false;
        }
        return masks;
    }

    private void parseOptions(List<String> args, Launcher launcher) {
        String[] split;
        String commandArgs = this.recorder.getCommandArgs_em();
        String escapedBackslash = null;
        while (commandArgs.contains(escapedBackslash = "--" + new Random().nextInt() + "--")) {
        }
        commandArgs = commandArgs.replaceAll("\\\\\\\\", escapedBackslash);
        String escapedDQuotes = null;
        while (commandArgs.contains(escapedDQuotes = "--" + new Random().nextInt() + "--")) {
        }
        commandArgs = commandArgs.replaceAll("\\\\\"", escapedDQuotes);
        String escapedSpaces = null;
        while (commandArgs.contains(escapedSpaces = "--" + new Random().nextInt() + "--")) {
        }
        String dquotes = null;
        while (commandArgs.contains(dquotes = "--" + new Random().nextInt() + "--")) {
        }
        Pattern compile = Pattern.compile("^([^\"]*)(\"[^\"]*\")(.*)$");
        Matcher matcher = compile.matcher(commandArgs);
        while (matcher.find()) {
            commandArgs = matcher.group(1) + matcher.group(2).replaceAll(" ", escapedSpaces).replaceAll("\"", dquotes) + matcher.group(3);
            matcher = compile.matcher(commandArgs);
        }
        for (String token : split = commandArgs.split("\\s+")) {
            token = token.replaceAll(dquotes, "\"").replaceAll(escapedSpaces, " ");
            token = token.replaceAll(escapedDQuotes, "\"");
            token = token.replaceAll(escapedBackslash, "\\\\");
            Matcher doubleQuotedTokenMatcher = Pattern.compile("^\"(.*)\"$").matcher(token);
            if (doubleQuotedTokenMatcher.find()) {
                token = doubleQuotedTokenMatcher.group(1);
            }
            args.add(KiuwanUtils.buildArgument(launcher, token));
        }
    }

    private void parseParameters(List<String> args, Launcher launcher) {
        String[] split;
        String extraParams = this.recorder.getExtraParameters_em();
        Pattern equalWithSpaces = Pattern.compile("^(.*\\s*[^=\\s]+)\\s+=\\s+(\".*\".*)$");
        Matcher equalsWithSpacesMatcher = equalWithSpaces.matcher(extraParams);
        while (equalsWithSpacesMatcher.find()) {
            extraParams = equalsWithSpacesMatcher.group(1) + "=" + equalsWithSpacesMatcher.group(2);
            equalsWithSpacesMatcher = equalWithSpaces.matcher(extraParams);
        }
        String escapedBackslash = null;
        while (extraParams.contains(escapedBackslash = "--" + new Random().nextInt() + "--")) {
        }
        extraParams = extraParams.replaceAll("\\\\\\\\", escapedBackslash);
        String escapedDQuotes = null;
        while (extraParams.contains(escapedDQuotes = "--" + new Random().nextInt() + "--")) {
        }
        extraParams = extraParams.replaceAll("\\\\\"", escapedDQuotes);
        String escapedSpaces = null;
        while (extraParams.contains(escapedSpaces = "--" + new Random().nextInt() + "--")) {
        }
        String dquotes = null;
        while (extraParams.contains(dquotes = "--" + new Random().nextInt() + "--")) {
        }
        Pattern compile = Pattern.compile("^([^\"]*)(\"[^\"]*\")(.*)$");
        Matcher matcher = compile.matcher(extraParams);
        while (matcher.find()) {
            extraParams = matcher.group(1) + matcher.group(2).replaceAll(" ", escapedSpaces).replaceAll("\"", dquotes) + matcher.group(3);
            matcher = compile.matcher(extraParams);
        }
        for (String token : split = extraParams.split("\\s+")) {
            token = token.replaceAll(dquotes, "\"").replaceAll(escapedSpaces, " ");
            token = token.replaceAll(escapedDQuotes, "\"");
            String[] paramValue = (token = token.replaceAll(escapedBackslash, "\\\\")).split("=", 2);
            if (paramValue.length != 2) continue;
            String key = paramValue[0];
            String value = paramValue[1];
            Matcher doubleQuotedTokenMatcher = Pattern.compile("^\"(.*)\"$").matcher(value);
            if (doubleQuotedTokenMatcher.find()) {
                value = doubleQuotedTokenMatcher.group(1);
            }
            args.add(KiuwanUtils.buildAdditionalParameterExpression(launcher, key, value));
        }
    }

    private FilePath resolveSrcFolder() throws IOException {
        FilePath srcFolder = null;
        if (StringUtils.isNotEmpty((String)this.recorder.getSourcePath())) {
            String sourcePath = this.recorder.getSourcePath();
            File sourcePathFile = new File(sourcePath);
            srcFolder = sourcePathFile.isAbsolute() ? new FilePath(sourcePathFile) : new FilePath(this.workspace, sourcePath);
        } else if (this.run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)this.run;
            srcFolder = build.getModuleRoot();
        }
        if (srcFolder == null) {
            throw new IOException("Could not resolver source folder. Source path = \"" + this.recorder.getSourcePath() + "\"");
        }
        return srcFolder;
    }

    private void writeConfigToProperties(FilePath agentBinDir) throws IOException, InterruptedException {
        FilePath agentPropertiesPath = agentBinDir.getParent().child(AGENT_CONF_DIR_NAME).child(AGENT_PROPERTIES_FILE_NAME);
        StringBuilder newFileContent = new StringBuilder();
        boolean updateConfig = true;
        String configSaveStamp = this.descriptor.getConfigSaveTimestamp();
        ProxyMode proxyMode = ProxyMode.valueFrom(this.connectionProfile.getConfigureProxy());
        boolean forceUpdate = ProxyMode.JENKINS.equals(proxyMode);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(agentPropertiesPath.read()));){
            boolean firstLineProcessed = false;
            String line = null;
            while (updateConfig && (line = reader.readLine()) != null) {
                if (!firstLineProcessed) {
                    Matcher matcher = Pattern.compile(kiuwanJenkinsPluginHeaderPattern).matcher(line);
                    if (matcher.find()) {
                        if (configSaveStamp != null) {
                            String stamp = matcher.group(1);
                            if (!forceUpdate && configSaveStamp.equals(stamp)) {
                                updateConfig = false;
                            }
                        } else {
                            updateConfig = false;
                        }
                    } else {
                        updateConfig = true;
                        if (configSaveStamp == null) {
                            configSaveStamp = Long.toHexString(System.currentTimeMillis());
                        }
                    }
                    if (updateConfig) {
                        newFileContent.append(kiuwanJenkinsPluginHeaderPrefix + configSaveStamp + kiuwanJenkinsPluginHeaderSuffix + "\n");
                    }
                    firstLineProcessed = true;
                }
                if (Pattern.matches(kiuwanJenkinsPluginHeaderPattern, line) || Pattern.matches(proxyHostRegExp, line) || Pattern.matches(proxyPortRegExp, line) || Pattern.matches(proxyProtocolRegExp, line) || Pattern.matches(proxyAuthenticationRegExp, line) || Pattern.matches(proxyUsernameRegExp, line) || Pattern.matches(proxyPasswordRegExp, line)) continue;
                newFileContent.append(line + "\n");
            }
        }
        if (updateConfig) {
            ProxyConfig proxyConfig = null;
            if (ProxyMode.NONE.equals(proxyMode)) {
                proxyConfig = ProxyConfig.EMPTY;
            } else if (ProxyMode.JENKINS.equals(proxyMode)) {
                proxyConfig = KiuwanUtils.getJenkinsProxy(null);
            } else if (ProxyMode.CUSTOM.equals(proxyMode)) {
                proxyConfig = new ProxyConfig(this.connectionProfile.getProxyHost(), this.connectionProfile.getProxyPort(), this.connectionProfile.getProxyProtocol(), this.connectionProfile.getProxyAuthentication(), this.connectionProfile.getProxyUsername(), this.connectionProfile.getProxyPassword());
            }
            if (proxyConfig != null) {
                newFileContent.append("proxy.host=" + proxyConfig.getHost() + "\n");
                newFileContent.append("proxy.port=" + proxyConfig.getPort() + "\n");
                newFileContent.append("proxy.protocol=" + proxyConfig.getLocalAnalyzerProtocolOption() + "\n");
                newFileContent.append("proxy.authentication=" + proxyConfig.getLocalAnalyzerAuthenticationOption() + "\n");
                newFileContent.append("proxy.username=" + proxyConfig.getUsername() + "\n");
                newFileContent.append("proxy.password=" + proxyConfig.getPassword() + "\n");
                agentPropertiesPath.write(newFileContent.toString(), "UTF-8");
            }
        }
    }
}

