/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.upgrade;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class UpgradeToConnectionProfiles {
    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static boolean upgradeConfiguration() {
        KiuwanGlobalConfigDescriptor instance = KiuwanGlobalConfigDescriptor.get();
        if (instance != null && instance.isConfigUpgradedToConnectionProfiles()) {
            return true;
        }
        File configFile = KiuwanGlobalConfigDescriptor.getGlobalConfigFile();
        File oldConfigFile = KiuwanGlobalConfigDescriptor.getOldGlobalConfigFile();
        boolean upgradeSuccessful = false;
        if (oldConfigFile.exists() && !configFile.exists()) {
            KiuwanUtils.logger().log(Level.INFO, "Kiuwan CONFIG upgrade to connection profiles process started");
            boolean oldDataRead = false;
            KiuwanConnectionProfile connectionProfile = new KiuwanConnectionProfile();
            try {
                XStream2 xstream2 = new XStream2();
                xstream2.addCompatibilityAlias("com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder$DescriptorImpl", KiuwanConnectionProfile.class);
                xstream2.addCompatibilityAlias("com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanDescriptor", KiuwanConnectionProfile.class);
                XmlFile oldXmlFile = new XmlFile((XStream)xstream2, oldConfigFile);
                oldXmlFile.unmarshal((Object)connectionProfile);
                oldDataRead = true;
            }
            catch (IOException e) {
                KiuwanUtils.logger().log(Level.SEVERE, "Could not read old data from " + oldConfigFile, e);
            }
            if (oldDataRead) {
                connectionProfile.setName("Kiuwan Connection Profile 1");
                ArrayList<KiuwanConnectionProfile> list = new ArrayList<KiuwanConnectionProfile>();
                list.add(connectionProfile);
                instance.setConnectionProfiles(list);
                instance.setUpgradeConfigToConnectionProfilesTimestamp(KiuwanUtils.getCurrentTimestampString());
                instance.save();
                upgradeSuccessful = true;
            }
            KiuwanUtils.logger().log(Level.INFO, "Kiuwan CONFIG upgrade to connection profiles process finished " + (upgradeSuccessful ? "successfully" : "with errors"));
        } else if (!oldConfigFile.exists() && !configFile.exists()) {
            instance.setUpgradeConfigToConnectionProfilesTimestamp(KiuwanUtils.getCurrentTimestampString());
            instance.save();
            upgradeSuccessful = true;
        }
        return upgradeSuccessful;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static boolean upgradeJobs() {
        KiuwanGlobalConfigDescriptor instance = KiuwanGlobalConfigDescriptor.get();
        String defaultConnectionProfileUuid = null;
        if (instance != null) {
            if (instance.isJobsUpgradedToConnectionProfiles()) {
                return true;
            }
            List<KiuwanConnectionProfile> connectionProfiles = instance.getConnectionProfiles();
            if (connectionProfiles != null && connectionProfiles.size() == 1) {
                defaultConnectionProfileUuid = connectionProfiles.iterator().next().getUuid();
            }
        }
        LinkedHashMap<AbstractProject, KiuwanRecorder> jobsWithKiuwanPublisherMap = new LinkedHashMap<AbstractProject, KiuwanRecorder>();
        for (AbstractProject job : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
            DescribableList publishers = job.getPublishersList();
            for (Publisher publisher : publishers) {
                if (!(publisher instanceof KiuwanRecorder)) continue;
                KiuwanRecorder kiuwanRecorder = (KiuwanRecorder)publisher;
                jobsWithKiuwanPublisherMap.put(job, kiuwanRecorder);
            }
        }
        boolean upgradeSuccessful = false;
        KiuwanUtils.logger().log(Level.INFO, "Kiuwan JOBS upgrade to connection profiles process started");
        if (jobsWithKiuwanPublisherMap.isEmpty()) {
            upgradeSuccessful = true;
        } else if (StringUtils.isNotEmpty((String)defaultConnectionProfileUuid)) {
            for (AbstractProject job : jobsWithKiuwanPublisherMap.keySet()) {
                KiuwanRecorder kiuwanRecorder = (KiuwanRecorder)((Object)jobsWithKiuwanPublisherMap.get(job));
                String connectionProfileUuid = kiuwanRecorder.getConnectionProfileUuid();
                if (connectionProfileUuid != null) continue;
                kiuwanRecorder.setOutputFilename("kiuwan/output.json");
                kiuwanRecorder.setConnectionProfileUuid(defaultConnectionProfileUuid);
                try {
                    job.save();
                }
                catch (IOException e) {
                    KiuwanUtils.logger().log(Level.SEVERE, "Could not save job " + job.getFullDisplayName() + " while upgrading Kiuwan publisher to connection profiles!", e);
                }
            }
            upgradeSuccessful = true;
        } else {
            KiuwanUtils.logger().log(Level.WARNING, "Kiuwan JOBS upgrade cannot be run: no default connection profile found");
        }
        if (upgradeSuccessful) {
            instance.setUpgradeJobsToConnectionProfilesTimestamp(KiuwanUtils.getCurrentTimestampString());
            instance.save();
        }
        KiuwanUtils.logger().log(Level.INFO, "Kiuwan JOBS upgrade to connection profiles process finished " + (upgradeSuccessful ? "successfully" : "with errors"));
        return upgradeSuccessful;
    }
}

